/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.jiffle;

import jaitools.CollectionFactory;
import jaitools.demo.ImageChoice;
import jaitools.demo.jiffle.JiffleDemoBase;
import jaitools.demo.jiffle.JiffleDemoHelper;
import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.swing.ImageFrame;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.Map;
import javax.media.jai.TiledImage;

public class DirectRuntimeDemo
extends JiffleDemoBase {
    public static void main(String[] args) throws Exception {
        DirectRuntimeDemo demo = new DirectRuntimeDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public void compileAndRun(File scriptFile) throws Exception {
        Map imageParams = CollectionFactory.map();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        Map images = CollectionFactory.map();
        images.put("result", ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0));
        if (jiffle.isCompiled()) {
            JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
            TiledImage destImg = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
            runtime.setDestinationImage("result", (WritableRenderedImage)destImg);
            runtime.evaluateAll(null);
            ImageFrame frame = new ImageFrame((RenderedImage)destImg, "Jiffle image demo");
            frame.setVisible(true);
        }
    }
}

