/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.jiffle;

import jaitools.CollectionFactory;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.JiffleException;
import jaitools.jiffle.runtime.AbstractDirectRuntime;
import jaitools.jiffle.runtime.AbstractProgressListener;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.jiffle.runtime.JiffleExecutor;
import jaitools.jiffle.runtime.JiffleExecutorException;
import jaitools.jiffle.runtime.JiffleProgressListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressListenerDemo {
    private static final int NUM_PIXELS = 500;
    private static final long PIXEL_TIME = 10L;

    public static void main(String[] args) throws Exception {
        ProgressListenerDemo me = new ProgressListenerDemo();
        me.demo();
    }

    private void demo() throws JiffleExecutorException {
        MyProgressListener listener = new MyProgressListener();
        listener.setUpdateInterval(0.1);
        JiffleExecutor executor = new JiffleExecutor();
        PretendJiffle jiffle = new PretendJiffle();
        Map emptyImageMap = CollectionFactory.map();
        executor.submit((Jiffle)jiffle, emptyImageMap, (JiffleProgressListener)listener);
    }

    class PretendJiffleRuntime
    extends AbstractDirectRuntime {
        public PretendJiffleRuntime() {
            this._width = 500;
            this._height = 1;
            this._minx = 0;
            this._miny = 0;
        }

        protected void initImageScopeVars() {
        }

        protected void initOptionVars() {
        }

        public void evaluate(int x, int y) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PretendJiffle
    extends Jiffle {
        PretendJiffle() {
        }

        public boolean isCompiled() {
            return true;
        }

        public Map<String, Jiffle.ImageRole> getImageParams() {
            Map emptyParams = CollectionFactory.map();
            return emptyParams;
        }

        public JiffleDirectRuntime getRuntimeInstance() throws JiffleException {
            return new PretendJiffleRuntime();
        }
    }

    class ProgressMeter
    extends JDialog {
        private JProgressBar bar;
        private JButton btn;

        public ProgressMeter() {
            this.setTitle("Trying to look busy");
            this.setSize(400, 80);
            this.initComponents();
            this.setModal(true);
        }

        private void initComponents() {
            JPanel panel = new JPanel(new BorderLayout());
            this.bar = new JProgressBar();
            this.bar.setMaximum(100);
            panel.add((Component)this.bar, "North");
            this.btn = new JButton("Working...");
            this.btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            this.btn.setEnabled(false);
            panel.add((Component)this.btn, "South");
            this.getContentPane().add(panel);
        }

        void update(final int progress) {
            if (EventQueue.isDispatchThread()) {
                this.bar.setValue(progress);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ProgressMeter.this.bar.setValue(progress);
                    }
                });
            }
        }

        void done() {
            String msg = "Finished";
            if (EventQueue.isDispatchThread()) {
                this.btn.setText("Finished");
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ProgressMeter.this.btn.setText("Finished");
                    }
                });
            }
            this.btn.setEnabled(true);
        }
    }

    class MyProgressListener
    extends AbstractProgressListener {
        ProgressMeter meter;

        public MyProgressListener() {
            this.meter = new ProgressMeter();
            this.meter.setLocationByPlatform(true);
        }

        public void start() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MyProgressListener.this.meter.setVisible(true);
                }
            });
        }

        public void update(long done) {
            int percent = (int)(100.0 * (double)done / (double)this.taskSize);
            this.meter.update(percent);
        }

        public void finish() {
            this.meter.done();
        }
    }
}

