/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.zonalstats;

import jaitools.jiffle.JiffleBuilder;
import jaitools.media.jai.zonalstats.Result;
import jaitools.media.jai.zonalstats.ZonalStats;
import jaitools.media.jai.zonalstats.ZonalStatsDescriptor;
import jaitools.numeric.Statistic;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Iterator;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class ZonalStatsDemo {
    private RenderedImage dataImg;
    private RenderedImage zoneImg;

    public static void main(String[] args) throws Exception {
        ZonalStatsDemo me = new ZonalStatsDemo();
        me.demo();
    }

    private void demo() {
        ParameterBlockJAI pb = new ParameterBlockJAI("zonalstats");
        pb.setSource("dataImage", (Object)this.dataImg);
        pb.setSource("zoneImage", (Object)this.zoneImg);
        Statistic[] statistics = new Statistic[]{Statistic.MIN, Statistic.MAX, Statistic.MEDIAN, Statistic.APPROX_MEDIAN, Statistic.SDEV};
        pb.setParameter("stats", (Object)statistics);
        RenderedOp zsImg = JAI.create((String)"zonalstats", (ParameterBlock)pb);
        ZonalStats zs = (ZonalStats)zsImg.getProperty(ZonalStatsDescriptor.ZONAL_STATS_PROPERTY);
        System.out.println("                               exact    approx");
        System.out.println(" band zone      min      max   median   median     sdev");
        System.out.println("-----------------------------------------------------------");
        boolean band = false;
        Iterator i$ = zs.getZones().iterator();
        while (i$.hasNext()) {
            int z = (Integer)i$.next();
            System.out.printf(" %4d %4d", 0, z);
            ZonalStats zoneSubset = zs.band(0).zone(z);
            for (Statistic s : statistics) {
                System.out.printf(" %8.4f", ((Result)zoneSubset.statistic(s).results().get(0)).getValue());
            }
            System.out.println();
        }
    }

    public ZonalStatsDemo() throws Exception {
        String script = "dataImg = rand(10); \nnumZones = 5; \nrowsPerZone = height() / numZones; \nzoneImg = y() / rowsPerZone + 1;";
        JiffleBuilder jb = new JiffleBuilder();
        jb.script(script).dest("dataImg", 500, 500).dest("zoneImg", 500, 500);
        jb.getRuntime().evaluateAll(null);
        this.dataImg = jb.getImage("dataImg");
        RenderedImage zoneImgDouble = jb.getImage("zoneImg");
        ParameterBlockJAI pb = new ParameterBlockJAI("format");
        pb.setSource("source0", (Object)zoneImgDouble);
        pb.setParameter("dataType", 3);
        this.zoneImg = JAI.create((String)"format", (ParameterBlock)pb);
    }
}

