/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.jiffle;

import jaitools.demo.ImageChoice;
import jaitools.demo.jiffle.JiffleDemoHelper;
import jaitools.jiffle.JiffleBuilder;
import jaitools.jiffle.JiffleException;
import jaitools.swing.SimpleImagePane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class JiffleDemo
extends JFrame {
    private SimpleImagePane imagePane;
    private JTextArea scriptPane;
    private JSplitPane splitPane;
    private int imageWidth = 400;
    private int imageHeight = 400;

    public static void main(String[] args) {
        JiffleDemo me = new JiffleDemo();
        me.setSize(800, 500);
        me.setVisible(true);
    }

    private JiffleDemo() {
        super("Jiffle scripting language");
        this.initComponents();
        this.setDefaultCloseOperation(3);
    }

    public void setVisible(boolean vis) {
        if (vis) {
            this.splitPane.setDividerLocation((int)((double)this.getWidth() * 0.45));
        }
        super.setVisible(vis);
    }

    private void initComponents() {
        JMenuItem item;
        this.imagePane = new SimpleImagePane();
        this.scriptPane = new JTextArea();
        this.scriptPane.setEditable(false);
        Font font = new Font("Courier", 0, 12);
        this.scriptPane.setFont(font);
        JScrollPane imageScroll = new JScrollPane((Component)this.imagePane);
        JScrollPane scriptScroll = new JScrollPane(this.scriptPane);
        this.splitPane = new JSplitPane(1, scriptScroll, imageScroll);
        Dimension minSize = new Dimension(100, 100);
        imageScroll.setMinimumSize(minSize);
        scriptScroll.setMinimumSize(minSize);
        this.getContentPane().add(this.splitPane);
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = new JMenu("File");
        JMenu scriptMenu = new JMenu("Example scripts");
        for (final ImageChoice choice : ImageChoice.values()) {
            item = new JMenuItem(choice.toString());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JiffleDemo.this.loadScript(choice);
                }
            });
            scriptMenu.add(item);
        }
        mainMenu.add(scriptMenu);
        menuBar.add(mainMenu);
        JMenu viewMenu = new JMenu("View");
        item = new JMenuItem("Bigger font");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JiffleDemo.this.setFontSize(1);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(38, 192));
        viewMenu.add(item);
        item = new JMenuItem("Smaller font");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JiffleDemo.this.setFontSize(-1);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(40, 192));
        viewMenu.add(item);
        menuBar.add(viewMenu);
        this.setJMenuBar(menuBar);
    }

    private void loadScript(ImageChoice imageChoice) {
        try {
            String script = JiffleDemoHelper.getScript(imageChoice);
            this.runScript(script, imageChoice.getDestImageVarName());
        }
        catch (JiffleException ex) {
            JOptionPane.showMessageDialog(this, "Problem loading the example script", "Bummer", 0);
        }
    }

    private void runScript(String script, String destVarName) {
        try {
            this.scriptPane.setText(script);
            JiffleBuilder builder = new JiffleBuilder();
            builder.script(script).dest(destVarName, this.imageWidth, this.imageHeight);
            RenderedImage image = builder.run().getImage(destVarName);
            this.imagePane.setImage(image);
        }
        catch (JiffleException ex) {
            JOptionPane.showMessageDialog(this, "Errors compiling or running the script", "Bummer", 0);
        }
    }

    private void setFontSize(int delta) {
        Font font = this.scriptPane.getFont();
        Font font2 = font.deriveFont((float)font.getSize() + (float)delta);
        this.scriptPane.setFont(font2);
    }
}

