/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.jiffle;

import jaitools.CollectionFactory;
import jaitools.demo.ImageChoice;
import jaitools.demo.jiffle.JiffleDemoBase;
import jaitools.demo.jiffle.JiffleDemoHelper;
import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.jiffle.runtime.JiffleEvent;
import jaitools.jiffle.runtime.JiffleEventListener;
import jaitools.jiffle.runtime.JiffleExecutor;
import jaitools.jiffle.runtime.JiffleExecutorResult;
import jaitools.jiffle.runtime.JiffleProgressListener;
import jaitools.jiffle.runtime.NullProgressListener;
import jaitools.swing.ImageFrame;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.Map;
import javax.media.jai.TiledImage;

public class JiffleExecutorDemo
extends JiffleDemoBase {
    private JiffleExecutor executor = new JiffleExecutor(1);

    public static void main(String[] args) throws Exception {
        JiffleExecutorDemo demo = new JiffleExecutorDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public JiffleExecutorDemo() {
        this.executor.addEventListener(new JiffleEventListener(){

            public void onCompletionEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onCompletion(ev);
            }

            public void onFailureEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onFailure(ev);
            }
        });
    }

    public void compileAndRun(File scriptFile) throws Exception {
        Map imageParams = CollectionFactory.map();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
        TiledImage destImage = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
        runtime.setDestinationImage("result", (WritableRenderedImage)destImage);
        this.executor.submit(runtime, (JiffleProgressListener)new NullProgressListener());
    }

    private void onCompletion(JiffleEvent ev) {
        JiffleExecutorResult result = ev.getResult();
        RenderedImage img = (RenderedImage)result.getImages().get("result");
        ImageFrame frame = new ImageFrame(img, "Jiffle image demo");
        frame.setVisible(true);
    }

    private void onFailure(JiffleEvent ev) {
        System.err.println("Bummer: script failed to run");
    }
}

