/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.kernelstats;

import jaitools.numeric.Statistic;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;

public class KernelStatsDescriptor
extends OperationDescriptorImpl {
    static final int STATS_ARG_INDEX = 0;
    static final int KERNEL_ARG_INDEX = 1;
    static final int BAND_ARG_INDEX = 2;
    static final int ROI_ARG_INDEX = 3;
    static final int MASKSRC_ARG_INDEX = 4;
    static final int MASKDEST_ARG_INDEX = 5;
    static final int NAN_ARG_INDEX = 6;
    static final int NO_RESULT_VALUE_ARG_INDEX = 7;
    private static final String[] paramNames = new String[]{"stats", "kernel", "band", "roi", "maskSource", "maskDest", "ignoreNaN", "nilValue"};
    private static final Class[] paramClasses = new Class[]{Statistic[].class, KernelJAI.class, Integer.class, ROI.class, Boolean.class, Boolean.class, Boolean.class, Number.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, 0, null, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, 0};

    public KernelStatsDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "KernelStats"}, {"LocalName", "KernelStats"}, {"Vendor", "jaitools.media.jai"}, {"Description", "Calculate neighbourhood statistics"}, {"DocURL", "http://code.google.com/p/jai-tools/"}, {"Version", "1.0.0"}, {"arg0Desc", "stats - an array of KernelStatistic constants specifying the statistics required"}, {"arg1Desc", "kernel - a JAI Kernel object"}, {"arg2Desc", "band (Integer, default 0) - the source image band to process"}, {"arg3Desc", "roi (default null) - an optional ROI object for source and/ordestination masking"}, {"arg4Desc", "maskSource (Boolean, default TRUE) -if TRUE only the values of source pixels whereroi.contains is true contribute to the statistic"}, {"arg5Desc", "maskdest (Boolean, default TRUE) - if TRUE calculation is only performedfor pixels where roi.contains is true; when falsethe destination pixel is set to NaN"}, {"arg6Desc", "ignorenan (Boolean, default TRUE) - if TRUE, NaN values in source float or double imagesare ignored; if FALSE any NaN values in a pixel's neighbourhoodwill result in nilValue for the destination pixel"}, {"arg7Desc", "nilValue (Number, default 0) - the nil value for destinationpixels that are outside the ROI (if destMask == TRUE), or that haveno neighbourhood values as a result of source masking, or NaN valuesin the neighbourhood and ignoreNaN == FALSE"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public static RenderedImage create(RenderedImage source0, Statistic[] stats, KernelJAI kernel, int band, ROI roi, Boolean maskSource, Boolean maskDest, Boolean ignoreNaN, Number nilValue, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("KernelStats", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("stats", (Object)stats);
        pb.setParameter("kernel", (Object)kernel);
        pb.setParameter("band", band);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("maskSource", (Object)maskSource);
        pb.setParameter("maskDest", (Object)maskDest);
        pb.setParameter("ignoreNaN", (Object)ignoreNaN);
        pb.setParameter("nilValue", (Object)nilValue);
        return JAI.create((String)"KernelStats", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        if (!super.validateArguments(modeName, pb, msg)) {
            return false;
        }
        int band = pb.getIntParameter(2);
        if (band < 0 || band >= pb.getNumSources()) {
            msg.append("band arg out of bounds for source image: " + band);
            return false;
        }
        return true;
    }
}

