/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import jaitools.CollectionFactory;
import jaitools.media.jai.zonalstats.Result;
import jaitools.numeric.Statistic;
import jaitools.numeric.StreamingSampleStats;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonalStats {
    private List<Result> results = CollectionFactory.list();

    ZonalStats() {
    }

    private ZonalStats(ZonalStats src, Integer band, Integer zone, Statistic stat) {
        for (Result r : src.results) {
            if (band != null && r.getImageBand() != band.intValue() || zone != null && r.getZone() != zone.intValue() || stat != null && r.getStatistic() != stat) continue;
            this.results.add(r);
        }
    }

    void setResults(int band, int zone, StreamingSampleStats stats) {
        for (Statistic s : stats.getStatistics()) {
            Result r = new Result(band, zone, s, stats.getStatisticValue(s), stats.getNumOffered(s), stats.getNumAccepted(s));
            this.results.add(r);
        }
    }

    public SortedSet<Integer> getZones() {
        SortedSet ids = CollectionFactory.sortedSet();
        for (Result r : this.results) {
            ids.add(r.getZone());
        }
        return ids;
    }

    public ZonalStats band(int b) {
        return new ZonalStats(this, b, null, null);
    }

    public ZonalStats zone(int z) {
        return new ZonalStats(this, null, z, null);
    }

    public ZonalStats statistic(Statistic s) {
        return new ZonalStats(this, null, null, s);
    }

    public List<Result> results() {
        return Collections.unmodifiableList(this.results);
    }
}

