/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import jaitools.numeric.Range;
import jaitools.numeric.Statistic;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonalStatsDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -526208282980300507L;
    public static String ZONAL_STATS_PROPERTY = "ZonalStatsProperty";
    static final int DATA_IMAGE = 0;
    static final int ZONE_IMAGE = 1;
    private static final String[] srcImageNames = new String[]{"dataImage", "zoneImage"};
    private static final Class<?>[][] srcImageClasses = new Class[][]{{RenderedImage.class, RenderedImage.class}};
    static final int STATS_ARG = 0;
    static final int BAND_ARG = 1;
    static final int ROI_ARG = 2;
    static final int ZONE_TRANSFORM_ARG = 3;
    static final int EXCLUDE_RANGE_ARG = 4;
    private static final String[] paramNames = new String[]{"stats", "bands", "roi", "zoneTransform", "exclude"};
    private static final Class<?>[] paramClasses = new Class[]{Statistic[].class, Integer[].class, ROI.class, AffineTransform.class, List.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer[]{0}, null, null, null};

    public ZonalStatsDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ZonalStats"}, {"LocalName", "ZonalStats"}, {"Vendor", "jaitools.media.jai"}, {"Description", "Calculate neighbourhood statistics"}, {"DocURL", "http://code.google.com/p/jai-tools/"}, {"Version", "1.0.0"}, {"arg0Desc", String.format("%s - an array of Statistic constants specifying the statistics required", paramNames[0])}, {"arg1Desc", String.format("%s (default %s) - the bands of the data image to process", paramNames[1], paramDefaults[1])}, {"arg2Desc", String.format("%s (default ) - an optional ROI for masking the data image", paramNames[2], paramDefaults[2])}, {"arg3Desc", String.format("%s (default %s) - an optional AffineTransform to map dataImage pixel coords to zoneImage pixel coords", paramNames[3], paramDefaults[3])}, {"arg4Desc", String.format("%s (default %s) - an optional List of Ranges that define dataImage values to exclude from calculations", paramNames[4], paramDefaults[4])}}, new String[]{"rendered"}, srcImageNames, (Class[][])srcImageClasses, paramNames, (Class[])paramClasses, paramDefaults, null);
    }

    public static RenderedImage create(RenderedImage dataImage, RenderedImage zoneImage, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform zoneTransform, List<Range<Double>> exclude, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ZonalStats", "rendered");
        pb.setSource(srcImageNames[0], (Object)dataImage);
        pb.setSource(srcImageNames[1], (Object)zoneImage);
        pb.setParameter(paramNames[0], (Object)stats);
        pb.setParameter(paramNames[1], (Object)bands);
        pb.setParameter(paramNames[2], (Object)roi);
        pb.setParameter(paramNames[3], (Object)zoneTransform);
        pb.setParameter(paramNames[4], exclude);
        return JAI.create((String)"ZonalStats", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public boolean arePropertiesSupported() {
        return true;
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        if (pb.getNumSources() == 0 || pb.getNumSources() > 2) {
            msg.append("ZonalStats operator takes 1 or 2 source images");
            return false;
        }
        Object rangeObject = pb.getObjectParameter(4);
        if (rangeObject != null) {
            boolean ok = true;
            if (rangeObject instanceof List) {
                Object range = ((List)rangeObject).get(0);
                if (!(range instanceof Range)) {
                    ok = false;
                }
            } else if (rangeObject != null) {
                ok = false;
            }
            if (!ok) {
                msg.append(paramNames[4] + " arg has to be of type List<Range<Double>>");
                return false;
            }
        }
        Object bandsObject = pb.getObjectParameter(1);
        Integer[] bands = null;
        if (!(bandsObject instanceof Integer[])) {
            msg.append(paramNames[1] + " arg has to be of type Integer[]");
            return false;
        }
        bands = (Integer[])bandsObject;
        RenderedImage dataImg = pb.getRenderedSource(0);
        for (Integer band : bands) {
            if (band >= 0 && band < dataImg.getSampleModel().getNumBands()) continue;
            msg.append("band index out of bounds for source image: " + band);
            return false;
        }
        Rectangle dataBounds = new Rectangle(dataImg.getMinX(), dataImg.getMinY(), dataImg.getWidth(), dataImg.getHeight());
        Object roiObject = pb.getObjectParameter(2);
        if (roiObject != null) {
            if (!(roiObject instanceof ROI)) {
                msg.append("The supplied ROI is not a supported class");
                return false;
            }
            if (!((ROI)roiObject).intersects(dataBounds)) {
                msg.append("The supplied ROI does not intersect the source image");
                return false;
            }
        }
        if (pb.getNumSources() == 2) {
            RenderedImage zoneImg = pb.getRenderedSource(1);
            int dataType = zoneImg.getSampleModel().getDataType();
            boolean integralType = false;
            if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
                integralType = true;
            }
            if (!integralType) {
                msg.append("The zone image must be an integral data type");
                return false;
            }
            AffineTransform tr = null;
            Object trObject = pb.getObjectParameter(3);
            if (trObject != null && !(trObject instanceof AffineTransform)) {
                msg.append("The supplied transform should be an instance of AffineTransform");
                return false;
            }
            tr = (AffineTransform)trObject;
            Rectangle zoneBounds = new Rectangle(zoneImg.getMinX(), zoneImg.getMinY(), zoneImg.getWidth(), zoneImg.getHeight());
            if (tr != null && !tr.isIdentity()) {
                Shape zoneBoundsTransformed = tr.createTransformedShape(zoneBounds);
                if (!zoneBoundsTransformed.intersects(dataBounds)) {
                    msg.append("Zone image bounds are outside the data image bounds");
                    return false;
                }
            } else if (!dataBounds.intersects(zoneBounds)) {
                msg.append("Zone image bounds are outside the data image bounds");
                return false;
            }
        }
        return true;
    }
}

