/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import jaitools.CollectionFactory;
import jaitools.media.jai.zonalstats.ZonalStats;
import jaitools.media.jai.zonalstats.ZonalStatsDescriptor;
import jaitools.numeric.Range;
import jaitools.numeric.RangeUtils;
import jaitools.numeric.Statistic;
import jaitools.numeric.StreamingSampleStats;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonalStatsOpImage
extends NullOpImage {
    private final Integer[] srcBands;
    private final ROI roi;
    private final Statistic[] stats;
    private final RenderedImage dataImage;
    private final Rectangle dataImageBounds;
    private final RenderedImage zoneImage;
    private final AffineTransform zoneTransform;
    private final List<Range<Double>> ranges;
    private final List<Range<Double>> noDataRanges;
    private final boolean rangeLocalStats;
    private Range.Type rangesType;
    private SortedSet<Integer> zones;

    public ZonalStatsOpImage(RenderedImage dataImage, RenderedImage zoneImage, Map<?, ?> config, ImageLayout layout, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform zoneTransform, List<Range<Double>> excludedRanges) {
        this(dataImage, zoneImage, config, layout, stats, bands, roi, zoneTransform, excludedRanges, Range.Type.EXCLUDE, false, null);
    }

    public ZonalStatsOpImage(RenderedImage dataImage, RenderedImage zoneImage, Map<?, ?> config, ImageLayout layout, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform zoneTransform, List<Range<Double>> ranges, Range.Type rangesType, boolean rangeLocalStats, List<Range<Double>> noDataRanges) {
        super(dataImage, layout, config, 1);
        this.dataImage = dataImage;
        this.zoneImage = zoneImage;
        this.dataImageBounds = new Rectangle(dataImage.getMinX(), dataImage.getMinY(), dataImage.getWidth(), dataImage.getHeight());
        this.stats = stats;
        this.srcBands = bands;
        this.roi = roi;
        this.zoneTransform = zoneTransform;
        this.rangeLocalStats = rangeLocalStats;
        this.ranges = CollectionFactory.list();
        this.rangesType = rangesType;
        if (ranges != null && !ranges.isEmpty()) {
            for (Range<Double> r : ranges) {
                this.ranges.add((Range<Double>)new Range(r));
            }
        }
        this.noDataRanges = CollectionFactory.list();
        if (noDataRanges != null && !noDataRanges.isEmpty()) {
            for (Range<Double> r : noDataRanges) {
                this.noDataRanges.add((Range<Double>)new Range(r));
            }
        }
    }

    private void buildZoneList() {
        this.zones = CollectionFactory.sortedSet();
        if (this.zoneImage != null) {
            RectIter iter = RectIterFactory.create((RenderedImage)this.zoneImage, null);
            while (true) {
                this.zones.add(iter.getSample());
                if (!iter.nextPixelDone()) continue;
                iter.startPixels();
                if (iter.nextLineDone()) break;
            }
        } else {
            this.zones.add(0);
        }
    }

    private synchronized ZonalStats compileStatistics() {
        if (this.zoneImage != null) {
            return this.compileZonalStatistics();
        }
        if (!this.rangeLocalStats) {
            return this.compileUnzonedStatistics();
        }
        return this.compileRangeStatistics();
    }

    private ZonalStats compileZonalStatistics() {
        int zone;
        Map resultPerBand;
        RectIter zoneIter;
        this.buildZoneList();
        SortedMap results = CollectionFactory.sortedMap();
        for (Integer srcBand : this.srcBands) {
            SortedMap resultsPerBand = CollectionFactory.sortedMap();
            results.put(srcBand, resultsPerBand);
            for (Integer zone2 : this.zones) {
                StreamingSampleStats sampleStats = new StreamingSampleStats(Range.Type.EXCLUDE);
                for (Range<Double> r : this.ranges) {
                    sampleStats.addRange(r);
                }
                for (Range<Double> r : this.noDataRanges) {
                    sampleStats.addNoDataRange(r);
                }
                sampleStats.setStatistics(this.stats);
                resultsPerBand.put(zone2, sampleStats);
            }
        }
        double[] sampleValues = new double[this.dataImage.getSampleModel().getNumBands()];
        RectIter dataIter = RectIterFactory.create((RenderedImage)this.dataImage, null);
        if (this.zoneTransform == null) {
            zoneIter = RectIterFactory.create((RenderedImage)this.zoneImage, (Rectangle)this.dataImageBounds);
            int y = this.dataImage.getMinY();
            do {
                int x = this.dataImage.getMinX();
                do {
                    if (this.roi == null || this.roi.contains(x, y)) {
                        dataIter.getPixel(sampleValues);
                        for (Integer band : this.srcBands) {
                            resultPerBand = (Map)results.get(band);
                            zone = zoneIter.getSample();
                            ((StreamingSampleStats)resultPerBand.get(zone)).offer(Double.valueOf(sampleValues[band]));
                        }
                    }
                    zoneIter.nextPixelDone();
                    ++x;
                } while (!dataIter.nextPixelDone());
                dataIter.startPixels();
                zoneIter.startPixels();
                zoneIter.nextLineDone();
            } while (!dataIter.nextLineDone());
        } else {
            zoneIter = RandomIterFactory.create((RenderedImage)this.zoneImage, (Rectangle)this.dataImageBounds);
            Point2D.Double dataPos = new Point2D.Double();
            Point2D.Double zonePos = new Point2D.Double();
            dataPos.y = this.dataImage.getMinY();
            do {
                dataPos.x = this.dataImage.getMinX();
                do {
                    if (this.roi == null | this.roi.contains((Point2D)dataPos)) {
                        dataIter.getPixel(sampleValues);
                        this.zoneTransform.transform(dataPos, zonePos);
                        for (Integer band : this.srcBands) {
                            resultPerBand = (Map)results.get(band);
                            zone = zoneIter.getSample((int)zonePos.x, (int)zonePos.y, 0);
                            ((StreamingSampleStats)resultPerBand.get(zone)).offer(Double.valueOf(sampleValues[band]));
                        }
                    }
                    dataPos.x += 1.0;
                } while (!dataIter.nextPixelDone());
                dataIter.startPixels();
                dataPos.y += 1.0;
            } while (!dataIter.nextLineDone());
        }
        ZonalStats zs = new ZonalStats();
        for (Integer band : this.srcBands) {
            for (Integer zone3 : this.zones) {
                zs.setResults(band, zone3, (StreamingSampleStats)((Map)results.get(band)).get(zone3));
            }
        }
        return zs;
    }

    private ZonalStats compileUnzonedStatistics() {
        int index;
        this.buildZoneList();
        Integer zoneID = this.zones.first();
        StreamingSampleStats[] sampleStatsPerBand = new StreamingSampleStats[this.srcBands.length];
        for (int index2 = 0; index2 < this.srcBands.length; ++index2) {
            StreamingSampleStats sampleStats = new StreamingSampleStats(this.rangesType);
            for (Range<Double> r : this.ranges) {
                sampleStats.addRange(r);
            }
            for (Range<Double> r : this.noDataRanges) {
                sampleStats.addNoDataRange(r);
            }
            sampleStats.setStatistics(this.stats);
            sampleStatsPerBand[index2] = sampleStats;
        }
        double[] sampleValues = new double[this.dataImage.getSampleModel().getNumBands()];
        RectIter dataIter = RectIterFactory.create((RenderedImage)this.dataImage, null);
        int y = this.dataImage.getMinY();
        do {
            int x = this.dataImage.getMinX();
            do {
                if (this.roi == null || this.roi.contains(x, y)) {
                    dataIter.getPixel(sampleValues);
                    for (index = 0; index < this.srcBands.length; ++index) {
                        double value = sampleValues[this.srcBands[index]];
                        sampleStatsPerBand[index].offer(Double.valueOf(value));
                    }
                }
                ++x;
            } while (!dataIter.nextPixelDone());
            dataIter.startPixels();
            ++y;
        } while (!dataIter.nextLineDone());
        ZonalStats zs = new ZonalStats();
        for (index = 0; index < this.srcBands.length; ++index) {
            StreamingSampleStats sampleStats = sampleStatsPerBand[index];
            List inclRanges = null;
            if (this.ranges != null && !this.ranges.isEmpty()) {
                switch (this.rangesType) {
                    case INCLUDE: {
                        inclRanges = CollectionFactory.list();
                        inclRanges.addAll(this.ranges);
                        break;
                    }
                    case EXCLUDE: {
                        inclRanges = CollectionFactory.list();
                        List incRanges = RangeUtils.createComplement((Collection)RangeUtils.sort(this.ranges));
                        inclRanges.addAll(incRanges);
                    }
                }
            }
            zs.setResults(this.srcBands[index], zoneID, sampleStats, inclRanges);
        }
        return zs;
    }

    private ZonalStats compileRangeStatistics() {
        this.buildZoneList();
        Integer zoneID = this.zones.first();
        ZonalStats zs = new ZonalStats();
        List localRanges = null;
        switch (this.rangesType) {
            case EXCLUDE: {
                List inRanges = RangeUtils.createComplement((Collection)RangeUtils.sort(this.ranges));
                localRanges = CollectionFactory.list();
                localRanges.addAll(inRanges);
                break;
            }
            case INCLUDE: {
                localRanges = CollectionFactory.list();
                localRanges.addAll(this.ranges);
                break;
            }
            case UNDEFINED: {
                throw new UnsupportedOperationException("Unable to compute range local statistics on UNDEFINED ranges type");
            }
        }
        for (Range range : localRanges) {
            StreamingSampleStats[] sampleStatsPerBand = new StreamingSampleStats[this.srcBands.length];
            for (int index = 0; index < this.srcBands.length; ++index) {
                StreamingSampleStats sampleStats = new StreamingSampleStats(this.rangesType);
                sampleStats.addRange(range);
                for (Range<Double> noDataRange : this.noDataRanges) {
                    sampleStats.addNoDataRange(noDataRange);
                }
                sampleStats.setStatistics(this.stats);
                sampleStatsPerBand[index] = sampleStats;
            }
            double[] sampleValues = new double[this.dataImage.getSampleModel().getNumBands()];
            RectIter dataIter = RectIterFactory.create((RenderedImage)this.dataImage, null);
            int y = this.dataImage.getMinY();
            do {
                int x = this.dataImage.getMinX();
                do {
                    if (this.roi == null || this.roi.contains(x, y)) {
                        dataIter.getPixel(sampleValues);
                        for (int index = 0; index < this.srcBands.length; ++index) {
                            double value = sampleValues[this.srcBands[index]];
                            sampleStatsPerBand[index].offer(Double.valueOf(value));
                        }
                    }
                    ++x;
                } while (!dataIter.nextPixelDone());
                dataIter.startPixels();
                ++y;
            } while (!dataIter.nextLineDone());
            for (int index = 0; index < this.srcBands.length; ++index) {
                StreamingSampleStats sampleStats = sampleStatsPerBand[index];
                List resultRanges = CollectionFactory.list();
                resultRanges.add(range);
                zs.setResults(this.srcBands[index], zoneID, sampleStats, resultRanges);
            }
        }
        return zs;
    }

    public Object getProperty(String name) {
        if (ZonalStatsDescriptor.ZONAL_STATS_PROPERTY.equalsIgnoreCase(name)) {
            return this.compileStatistics();
        }
        return super.getProperty(name);
    }

    public Class<?> getPropertyClass(String name) {
        if (ZonalStatsDescriptor.ZONAL_STATS_PROPERTY.equalsIgnoreCase(name)) {
            return Map.class;
        }
        return super.getPropertyClass(name);
    }

    public String[] getPropertyNames() {
        String[] names;
        int k = 0;
        String[] superNames = super.getPropertyNames();
        if (superNames != null) {
            names = new String[superNames.length + 1];
            for (String name : super.getPropertyNames()) {
                names[k++] = name;
            }
        } else {
            names = new String[1];
        }
        names[k] = ZonalStatsDescriptor.ZONAL_STATS_PROPERTY;
        return names;
    }
}

