/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.common.requirements;

import com.googlecode.jbp.common.requirements.IRequirements;
import com.googlecode.jbp.common.requirements.ParamRequirements;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequirements
implements IRequirements {
    private String concatenateStrings(String stringParam, String ... stringsParam) {
        ParamRequirements.INSTANCE.requireNotNull(stringParam, new String[0]);
        String result = stringParam;
        if (stringsParam != null) {
            StringBuilder sb = new StringBuilder(stringParam);
            for (String current : stringsParam) {
                sb.append(" ").append(current);
            }
            result = sb.toString();
        }
        return result;
    }

    protected abstract void onConditionNotMet(String var1);

    @Override
    public final <T extends Collection<?>> T requireAllInstanceOf(T collParam, Class<?> klassParam, String ... messagesParam) {
        this.requireNotNull(collParam, new String[0]);
        this.requireNotNull(klassParam, new String[0]);
        for (Object current : collParam) {
            if (klassParam.isAssignableFrom(current.getClass())) continue;
            String message = this.concatenateStrings("Requires all collection elements of class: ".concat(klassParam.getName()), messagesParam);
            this.onConditionNotMet(message);
        }
        return collParam;
    }

    @Override
    public final boolean requireConjunction(boolean ... predicatesParam) {
        ParamRequirements.INSTANCE.requireTrue(predicatesParam.length > 0, new String[0]);
        for (boolean current : predicatesParam) {
            if (current) continue;
            this.onConditionNotMet("Requires the conjunction of all predicates (all must be 'true').");
        }
        return true;
    }

    @Override
    public final File requireDirectory(File fileParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(fileParam, new String[0]);
        if (!fileParam.isDirectory()) {
            String message = this.concatenateStrings("Requires that file is a directory: ".concat(fileParam.getPath()), messagesParam);
            this.onConditionNotMet(message);
        }
        return fileParam;
    }

    @Override
    public final String requireDirectory(String filePathParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotBlank(filePathParam, new String[0]);
        File file = new File(filePathParam);
        if (!file.isDirectory()) {
            String message = this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), messagesParam);
            this.onConditionNotMet(message);
        }
        return filePathParam;
    }

    @Override
    public final boolean requireDisjunction(boolean ... predicatesParam) {
        ParamRequirements.INSTANCE.requireTrue(predicatesParam.length > 0, new String[0]);
        boolean currentDisjunction = false;
        for (int i = 0; i < predicatesParam.length && !currentDisjunction; ++i) {
            currentDisjunction = predicatesParam[i];
        }
        if (!currentDisjunction) {
            this.onConditionNotMet("Requires the disjunction of all predicates (at least one 'true').");
        }
        return true;
    }

    @Override
    public final boolean requireExclusiveDisjunction(boolean firstPredicateParam, boolean secondPredicateParam) {
        if (firstPredicateParam == secondPredicateParam) {
            this.onConditionNotMet("Requires an exclusive disjunction of the predicates (at least one true, but not both at once).");
        }
        return true;
    }

    @Override
    public final File requireExistingFile(File fileParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(fileParam, new String[0]);
        if (!fileParam.exists()) {
            String message = this.concatenateStrings("Requires that file exists: ".concat(fileParam.getPath()), messagesParam);
            this.onConditionNotMet(message);
        }
        return fileParam;
    }

    @Override
    public final String requireExistingFile(String filePathParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotBlank(filePathParam, new String[0]);
        File file = new File(filePathParam);
        if (!file.exists()) {
            String message = this.concatenateStrings("Requires that file exists: ".concat(filePathParam), messagesParam);
            this.onConditionNotMet(message);
        }
        return filePathParam;
    }

    @Override
    public final boolean requireFalse(boolean boolParam, String ... messagesParam) {
        if (boolParam) {
            String message = this.concatenateStrings("Requires that the specified expression returns false.", messagesParam);
            this.onConditionNotMet(message);
        }
        return false;
    }

    @Override
    public final Calendar requireFutureInstant(Calendar calendarParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(calendarParam, new String[0]);
        if (calendarParam.before(new Date())) {
            String message = "Passed calendar must not be a past date.";
            this.onConditionNotMet("Passed calendar must not be a past date.");
        }
        return calendarParam;
    }

    @Override
    public final Date requireFutureInstant(Date dateParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(dateParam, new String[0]);
        if (dateParam.before(new Date())) {
            String message = "Passed date must not be a past date.";
            this.onConditionNotMet("Passed date must not be a past date.");
        }
        return dateParam;
    }

    @Override
    public final <T> T requireInstanceOf(T objParam, Class<?> klassParam, String ... messagesParam) {
        this.requireNotNull(objParam, new String[0]);
        this.requireNotNull(klassParam, new String[0]);
        if (!klassParam.isAssignableFrom(objParam.getClass())) {
            String message = this.concatenateStrings("Requires parameter is instance of class: ".concat(klassParam.getName()), messagesParam);
            this.onConditionNotMet(message);
        }
        return objParam;
    }

    @Override
    public final Object[] requireNotAllSimultaneouslyNull(Object ... objectsParam) {
        boolean oneNotNull = false;
        for (Object current : objectsParam) {
            if (current == null) continue;
            oneNotNull = true;
            break;
        }
        if (!oneNotNull) {
            this.onConditionNotMet("At least one object must not be null.");
        }
        return objectsParam;
    }

    @Override
    public final <T extends Collection<?>> T requireNotAllSimultaneouslyNull(T coll, String ... messagesParam) {
        boolean oneNotNull = false;
        for (Object current : coll) {
            if (current == null) continue;
            oneNotNull = true;
            break;
        }
        if (!oneNotNull) {
            String message = this.concatenateStrings("Requires at least one non null element in collection.", messagesParam);
            this.onConditionNotMet(message);
        }
        return coll;
    }

    @Override
    public final String requireNotBlank(String strParam, String ... messagesParam) {
        if (strParam == null || StringUtils.isBlank((String)strParam)) {
            String message = this.concatenateStrings("Requires non blank String.", messagesParam);
            this.onConditionNotMet(message);
        }
        return strParam;
    }

    @Override
    public final <T extends Collection<?>> T requireNotEmpty(T collParam, String ... messagesParam) {
        this.requireNotNull(collParam, new String[0]);
        if (collParam.isEmpty()) {
            String message = this.concatenateStrings("Requires not empty collection.", messagesParam);
            this.onConditionNotMet(message);
        }
        return collParam;
    }

    @Override
    public final File requireNotExistingFile(File fileParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(fileParam, new String[0]);
        if (fileParam.exists()) {
            String message = this.concatenateStrings("Requires that file does not exist: ".concat(fileParam.getPath()), messagesParam);
            this.onConditionNotMet(message);
        }
        return fileParam;
    }

    @Override
    public final String requireNotExistingFile(String filePathParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotBlank(filePathParam, new String[0]);
        File file = new File(filePathParam);
        if (file.exists()) {
            String message = this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), messagesParam);
            this.onConditionNotMet(message);
        }
        return filePathParam;
    }

    @Override
    public final <T extends Number> T requireNotNegative(T n, String ... messagesParam) {
        this.requireNotNull(n, new String[0]);
        if (0.0 > n.doubleValue()) {
            String message = this.concatenateStrings("Requires a number that is not negative.", messagesParam);
            this.onConditionNotMet(message);
        }
        return n;
    }

    @Override
    public final <T extends Number> T requireNotNegativeNorZero(T n, String ... messagesParam) {
        this.requireNotNull(n, new String[0]);
        if (0.0 >= n.doubleValue()) {
            String message = this.concatenateStrings("Requires a number that is not negative nor zero.", messagesParam);
            this.onConditionNotMet(message);
        }
        return n;
    }

    @Override
    public final <T> T requireNotNull(T objParam, String ... messagesParam) {
        if (objParam == null) {
            String message = this.concatenateStrings("Requires a non null object.", messagesParam);
            this.onConditionNotMet(message);
        }
        return objParam;
    }

    @Override
    public final <T extends Number> T requireNotPositive(T n, String ... messagesParam) {
        this.requireNotNull(n, new String[0]);
        if (0.0 < n.doubleValue()) {
            String message = this.concatenateStrings("Requires a number that is not positive.", messagesParam);
            this.onConditionNotMet(message);
        }
        return n;
    }

    @Override
    public final <T extends Number> T requireNotPositiveNorZero(T n, String ... messagesParam) {
        this.requireNotNull(n, new String[0]);
        if (0.0 <= n.doubleValue()) {
            String message = this.concatenateStrings("Requires a number that is not positive nor zero.", messagesParam);
            this.onConditionNotMet(message);
        }
        return n;
    }

    @Override
    public final <T extends Number> T requireNotZero(T n, String ... messagesParam) {
        this.requireNotNull(n, new String[0]);
        if (0.0 == n.doubleValue()) {
            String message = this.concatenateStrings("Requires a number that is not zero.", messagesParam);
            this.onConditionNotMet(message);
        }
        return n;
    }

    @Override
    public final <T> T requireNull(T objParam, String ... messagesParam) {
        if (objParam != null) {
            String message = this.concatenateStrings("Requires a null object.", messagesParam);
            this.onConditionNotMet(message);
        }
        return objParam;
    }

    @Override
    public final Calendar requirePastInstant(Calendar calendarParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(calendarParam, new String[0]);
        if (calendarParam.after(new Date())) {
            String message = "Passed calendar must not be a past date.";
            this.onConditionNotMet("Passed calendar must not be a past date.");
        }
        return calendarParam;
    }

    @Override
    public final Date requirePastInstant(Date dateParam, String ... messagesParam) {
        ParamRequirements.INSTANCE.requireNotNull(dateParam, new String[0]);
        if (dateParam.after(new Date())) {
            String message = "Passed date must not be a future date.";
            this.onConditionNotMet("Passed date must not be a future date.");
        }
        return dateParam;
    }

    @Override
    public final boolean requireTrue(boolean boolParam, String ... messagesParam) {
        if (!boolParam) {
            String message = this.concatenateStrings("Requires that the specified expression returns true.", messagesParam);
            this.onConditionNotMet(message);
        }
        return true;
    }
}

