/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.common.annotations;

import com.googlecode.jbp.common.requirements.Reqs;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static boolean isQualifiedAnnotationPresent(Class<?> classParam, Class<? extends Annotation> annotationQualifierClass) {
        Annotation[] annotations;
        Reqs.PARAM_REQ.Object.requireNotNull(classParam, "The class that may be annotated must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(annotationQualifierClass, "The qualifying annotation's class must not be null.");
        Target targetAnnot = annotationQualifierClass.getAnnotation(Target.class);
        ElementType[] elementTypes = targetAnnot.value();
        Reqs.PARAM_REQ.Logic.requireTrue(Arrays.asList(elementTypes).contains((Object)ElementType.ANNOTATION_TYPE), "The specified annotations qualifier class must have the target element type ANNOTATION_TYPE, but does not.");
        Reqs.PARAM_REQ.Logic.requireTrue(annotationQualifierClass.isAnnotation(), "Parameter 'annotationQualifierClass' must be the Class of an annotations type, but is not.");
        for (Annotation annotation : annotations = classParam.getAnnotations()) {
            if (!AnnotationHelper.isQualifiedAnnotation(annotation.getClass(), annotationQualifierClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQualifiedAnnotation(Class<? extends Annotation> annotationClassParam, Class<? extends Annotation> annotationQualifierClassParam) {
        Class<?>[] interfaces;
        Reqs.PARAM_REQ.Object.requireNotNull(annotationClassParam, "Qualified annotation's class parameter must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(annotationQualifierClassParam, "Qualifying annotation's class parameter must not be null.");
        if (annotationClassParam.isAnnotationPresent(annotationQualifierClassParam)) {
            return true;
        }
        for (Class<?> current : interfaces = annotationClassParam.getInterfaces()) {
            if (!current.isAnnotationPresent(annotationQualifierClassParam)) continue;
            return true;
        }
        return false;
    }

    public static List<Annotation> getQualifiedAnnotations(Class<?> classParam, Class<? extends Annotation> annotationQualifierClass) {
        Annotation[] annotations;
        Reqs.PARAM_REQ.Object.requireNotNull(classParam, "The annotated class must not be null.");
        Reqs.PARAM_REQ.Object.requireNotNull(annotationQualifierClass, "The qualifying annotation class must not be null.");
        Target targetAnnot = annotationQualifierClass.getAnnotation(Target.class);
        ElementType[] elementTypes = targetAnnot.value();
        Reqs.PARAM_REQ.Logic.requireTrue(Arrays.asList(elementTypes).contains((Object)ElementType.ANNOTATION_TYPE), "The specified annotations qualifier class must have the target element type ANNOTATION_TYPE, but does not.");
        Reqs.PARAM_REQ.Logic.requireTrue(annotationQualifierClass.isAnnotation(), "Parameter 'annotationQualifierClass' must be the Class of an annotations type, but is not.");
        ArrayList<Annotation> qualifiedAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = classParam.getAnnotations()) {
            if (!AnnotationHelper.isQualifiedAnnotation(annotation.getClass(), annotationQualifierClass)) continue;
            qualifiedAnnotations.add(annotation);
        }
        return Collections.unmodifiableList(qualifiedAnnotations);
    }
}

