/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.common.logic;

import com.googlecode.jbp.common.requirements.Reqs;

public class BooleanFunctions {
    public static boolean conjunction(boolean ... predicatesParam) {
        Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "The length of the predicates array must be >0.");
        for (boolean current : predicatesParam) {
            if (current) continue;
            return false;
        }
        return true;
    }

    public static boolean disjunction(boolean ... predicatesParam) {
        Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "The length of the predicates array must be >0.");
        boolean disjunction = false;
        for (int i = 0; i < predicatesParam.length && !disjunction; ++i) {
            disjunction = disjunction || predicatesParam[i];
        }
        return disjunction;
    }

    public static boolean equivalent(boolean ... predicatesParam) {
        Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "The length of the predicates array must be >0.");
        boolean equivalent = true;
        for (int i = 0; i < predicatesParam.length - 1 && equivalent; ++i) {
            equivalent = !BooleanFunctions.exclusiveDisjunction(predicatesParam[i], predicatesParam[i + 1]);
        }
        return equivalent;
    }

    public static boolean exclusiveDisjunction(boolean firstPredicateParam, boolean secondPredicateParam) {
        return firstPredicateParam != secondPredicateParam;
    }

    public static boolean majority(boolean ... predicatesParam) {
        Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "The length of the predicates array must be >0.");
        int count = 0;
        int halfQuantity = predicatesParam.length / 2;
        for (int i = 0; i < predicatesParam.length && count <= halfQuantity; ++i) {
            if (!predicatesParam[i]) continue;
            ++count;
        }
        return count > halfQuantity;
    }

    public static boolean nand(boolean firstPredicateParam, boolean secondPredicateParam) {
        return !firstPredicateParam || !secondPredicateParam;
    }

    public static boolean nor(boolean firstPredicateParam, boolean secondPredicateParam) {
        return !firstPredicateParam && !secondPredicateParam;
    }

    public static boolean not(boolean predicateParam) {
        return !predicateParam;
    }

    public static boolean[] not(boolean ... predicatesParam) {
        Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "The length of the predicates array must be >0.");
        boolean[] notPredicates = new boolean[predicatesParam.length];
        for (int i = 0; i < predicatesParam.length; ++i) {
            notPredicates[i] = !predicatesParam[i];
        }
        return notPredicates;
    }

    private BooleanFunctions() {
        throw new IllegalStateException("This class must not be instanciated.");
    }
}

