/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.common.requirements;

import com.googlecode.jbp.common.requirements.IDateTimeRequirements;
import com.googlecode.jbp.common.requirements.IFileRequirements;
import com.googlecode.jbp.common.requirements.ILogicRequirements;
import com.googlecode.jbp.common.requirements.INumberRequirements;
import com.googlecode.jbp.common.requirements.IObjectRequirements;
import com.googlecode.jbp.common.requirements.IStringRequirements;
import com.googlecode.jbp.common.requirements.Reqs;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRequirements {
    public final IStringRequirements String = new IStringRequirements(){

        public final String requireNotBlank(String strParam, String ... messagesParam) {
            if (strParam == null || StringUtils.isBlank((String)strParam)) {
                String message = AbstractRequirements.this.concatenateStrings("Requires non blank String.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return strParam;
        }

        public final String requireNotBlank(String strParam, String msgParam) {
            if (strParam == null || StringUtils.isBlank((String)strParam)) {
                String message = AbstractRequirements.this.concatenateStrings("Requires non blank String.", new String[]{msgParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return strParam;
        }
    };
    public final ILogicRequirements Logic = new ILogicRequirements(){

        public final boolean requireConjunction(boolean ... predicatesParam) {
            Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "Parameter array predicatesParam must have a length >0");
            for (boolean current : predicatesParam) {
                if (current) continue;
                AbstractRequirements.this.onConditionNotMet("Requires the conjunction of all predicates (all must be 'true').");
            }
            return true;
        }

        public final boolean requireDisjunction(boolean ... predicatesParam) {
            Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "Parameter array predicatesParam must have a length >0");
            boolean currentDisjunction = false;
            for (int i = 0; i < predicatesParam.length && !currentDisjunction; ++i) {
                currentDisjunction = predicatesParam[i];
            }
            if (!currentDisjunction) {
                AbstractRequirements.this.onConditionNotMet("Requires the disjunction of all predicates (at least one 'true').");
            }
            return true;
        }

        public final boolean requireExclusiveDisjunction(boolean firstPredicateParam, boolean secondPredicateParam) {
            if (firstPredicateParam == secondPredicateParam) {
                AbstractRequirements.this.onConditionNotMet("Requires an exclusive disjunction of the predicates (at least one true, but not both at once).");
            }
            return true;
        }

        public final boolean requireFalse(boolean boolParam, String ... messagesParam) {
            if (boolParam) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that the specified expression returns false.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return false;
        }

        public final boolean requireTrue(boolean boolParam, String ... messagesParam) {
            if (!boolParam) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that the specified expression returns true.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return true;
        }

        public final boolean requireConjunction(String messageParam, boolean ... predicatesParam) {
            Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "Parameter array predicatesParam must have a length >0");
            for (boolean current : predicatesParam) {
                if (current) continue;
                String message = AbstractRequirements.this.concatenateStrings("Requires the conjunction of all predicates (all must be 'true').", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return true;
        }

        public final boolean requireDisjunction(String messageParam, boolean ... predicatesParam) {
            Reqs.PARAM_REQ.Logic.requireTrue(predicatesParam.length > 0, "Parameter array predicatesParam must have a length >0");
            boolean currentDisjunction = false;
            for (int i = 0; i < predicatesParam.length && !currentDisjunction; ++i) {
                currentDisjunction = predicatesParam[i];
            }
            if (!currentDisjunction) {
                String message = AbstractRequirements.this.concatenateStrings("Requires the disjunction of all predicates (at least one 'true').", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return true;
        }

        public final boolean requireExclusiveDisjunction(boolean firstPredicateParam, boolean secondPredicateParam, String messageParam) {
            if (firstPredicateParam == secondPredicateParam) {
                String message = AbstractRequirements.this.concatenateStrings("Requires an exclusive disjunction of the predicates (at least one true, but not both at once).", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return true;
        }

        public final boolean requireFalse(boolean boolParam, String messageParam) {
            if (boolParam) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that the specified expression returns false.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return false;
        }

        public final boolean requireTrue(boolean boolParam, String messageParam) {
            if (!boolParam) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that the specified expression returns true.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return true;
        }
    };
    public final IObjectRequirements Object = new IObjectRequirements(){

        @Override
        public final <T extends Collection<?>> T requireAllInstanceOf(T collParam, Class<?> klassParam, String ... messagesParam) {
            this.requireNotNull(collParam, new String[0]);
            this.requireNotNull(klassParam, new String[0]);
            for (Object current : collParam) {
                if (klassParam.isAssignableFrom(current.getClass())) continue;
                String message = AbstractRequirements.this.concatenateStrings("Requires all collection elements of class: ".concat(klassParam.getName()), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return collParam;
        }

        @Override
        public final <T extends Collection<?>> T requireNotEmpty(T collParam, String ... messagesParam) {
            this.requireNotNull(collParam, new String[0]);
            if (collParam.isEmpty()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires not empty collection.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return collParam;
        }

        @Override
        public final <T> T requireNotNull(T objParam, String ... messagesParam) {
            if (objParam == null) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a non null object.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final <T> T requireNull(T objParam, String ... messagesParam) {
            if (objParam != null) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a null object.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final <T> T requireInstanceOf(T objParam, Class<?> klassParam, String ... messagesParam) {
            this.requireNotNull(objParam, new String[0]);
            this.requireNotNull(klassParam, new String[0]);
            if (!klassParam.isAssignableFrom(objParam.getClass())) {
                String message = AbstractRequirements.this.concatenateStrings("Requires parameter is instance of class: ".concat(klassParam.getName()), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final Object[] requireNotAllSimultaneouslyNull(Object ... objectsParam) {
            boolean oneNotNull = false;
            for (Object current : objectsParam) {
                if (current == null) continue;
                oneNotNull = true;
                break;
            }
            if (!oneNotNull) {
                AbstractRequirements.this.onConditionNotMet("At least one object must not be null.");
            }
            return objectsParam;
        }

        @Override
        public final <T extends Collection<?>> T requireNotAllSimultaneouslyNull(T coll, String ... messagesParam) {
            boolean oneNotNull = false;
            for (Object current : coll) {
                if (current == null) continue;
                oneNotNull = true;
                break;
            }
            if (!oneNotNull) {
                String message = AbstractRequirements.this.concatenateStrings("Requires at least one non null element in collection.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return coll;
        }

        @Override
        public final <T extends Collection<?>> T requireAllInstanceOf(T collParam, Class<?> klassParam, String messageParam) {
            this.requireNotNull(collParam, new String[0]);
            this.requireNotNull(klassParam, new String[0]);
            for (Object current : collParam) {
                if (klassParam.isAssignableFrom(current.getClass())) continue;
                String message = AbstractRequirements.this.concatenateStrings("Requires all collection elements of class: ".concat(klassParam.getName()), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return collParam;
        }

        @Override
        public final <T extends Collection<?>> T requireNotEmpty(T collParam, String messageParam) {
            this.requireNotNull(collParam, new String[0]);
            if (collParam.isEmpty()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires not empty collection.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return collParam;
        }

        @Override
        public final <T> T requireNotNull(T objParam, String messageParam) {
            if (objParam == null) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a non null object.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final <T> T requireNull(T objParam, String messageParam) {
            if (objParam != null) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a null object.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final <T> T requireInstanceOf(T objParam, Class<?> klassParam, String messageParam) {
            this.requireNotNull(objParam, new String[0]);
            this.requireNotNull(klassParam, new String[0]);
            if (!klassParam.isAssignableFrom(objParam.getClass())) {
                String message = AbstractRequirements.this.concatenateStrings("Requires parameter is instance of class: ".concat(klassParam.getName()), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objParam;
        }

        @Override
        public final Object[] requireNotAllSimultaneouslyNull(String msgParam, Object ... objectsParam) {
            boolean oneNotNull = false;
            for (Object current : objectsParam) {
                if (current == null) continue;
                oneNotNull = true;
                break;
            }
            if (!oneNotNull) {
                String message = AbstractRequirements.this.concatenateStrings("Requires at least one non null element in collection.", new String[]{msgParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return objectsParam;
        }

        @Override
        public final <T extends Collection<?>> T requireNotAllSimultaneouslyNull(T coll, String messageParam) {
            boolean oneNotNull = false;
            for (Object current : coll) {
                if (current == null) continue;
                oneNotNull = true;
                break;
            }
            if (!oneNotNull) {
                String message = AbstractRequirements.this.concatenateStrings("Requires at least one non null element in collection.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return coll;
        }
    };
    public final IDateTimeRequirements DateTime = new IDateTimeRequirements(){

        public final Calendar requirePastInstant(Calendar calendarParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(calendarParam, "Parameter calendarParam must not be null.");
            if (calendarParam.after(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed calendar must not be a past date.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return calendarParam;
        }

        public final Date requirePastInstant(Date dateParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(dateParam, "Parameter dateParam must not be null.");
            if (dateParam.after(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed date must not be a future date.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return dateParam;
        }

        public final Calendar requireFutureInstant(Calendar calendarParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(calendarParam, "Parameter calendarParam must not be null.");
            if (calendarParam.before(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed calendar must not be a past date.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return calendarParam;
        }

        public final Date requireFutureInstant(Date dateParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(dateParam, "Parameter dateParam must not be null.");
            if (dateParam.before(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed date must not be a past date.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return dateParam;
        }

        public final Calendar requirePastInstant(Calendar calendarParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(calendarParam, "Parameter calendarParam must not be null.");
            if (calendarParam.after(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed calendar must not be a past date.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return calendarParam;
        }

        public final Date requirePastInstant(Date dateParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(dateParam, "Parameter dateParam must not be null.");
            if (dateParam.after(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed date must not be a future date.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return dateParam;
        }

        public final Calendar requireFutureInstant(Calendar calendarParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(calendarParam, "Parameter calendarParam must not be null.");
            if (calendarParam.before(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed calendar must not be a past date.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return calendarParam;
        }

        public final Date requireFutureInstant(Date dateParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(dateParam, "Parameter dateParam must not be null.");
            if (dateParam.before(new Date())) {
                String message = AbstractRequirements.this.concatenateStrings("Passed date must not be a past date.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return dateParam;
        }
    };
    public final INumberRequirements Number = new INumberRequirements(){

        @Override
        public final <T extends Number> T requireNotStrictlyNegative(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 > n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not negative.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotNegative(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 >= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not negative nor zero.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireStrictlyNegative(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 <= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is strictly negative.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireNegative(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 < n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is negative.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireStrictlyPositive(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 >= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is strictly positive.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requirePositive(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 > n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is positive.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotStrictlyPositive(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 < n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not positive.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotPositive(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 <= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not positive nor zero.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotZero(T n, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 == n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not zero.", messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotStrictlyNegative(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 > n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not negative.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotNegative(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 >= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not negative nor zero.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireStrictlyNegative(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 <= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is strictly negative.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireNegative(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 < n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is negative.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requireStrictlyPositive(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 >= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is strictly positive.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public <T extends Number> T requirePositive(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 > n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is positive.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotStrictlyPositive(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 < n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not positive.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotPositive(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 <= n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not positive nor zero.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }

        @Override
        public final <T extends Number> T requireNotZero(T n, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(n, "Parameter n must not be null.");
            if (0.0 == n.doubleValue()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires a number that is not zero.", new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return n;
        }
    };
    public final IFileRequirements File = new IFileRequirements(){

        public final File requireDirectory(File fileParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (!fileParam.isDirectory()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(fileParam.getPath()), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireDirectory(String filePathParam, String ... messagesParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (!file.isDirectory()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }

        public final File requireExistingFile(File fileParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (!fileParam.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file exists: ".concat(fileParam.getPath()), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireExistingFile(String filePathParam, String ... messagesParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (!file.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file exists: ".concat(filePathParam), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }

        public final File requireNotExistingFile(File fileParam, String ... messagesParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (fileParam.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file does not exist: ".concat(fileParam.getPath()), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireNotExistingFile(String filePathParam, String ... messagesParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (file.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), messagesParam);
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }

        public final File requireDirectory(File fileParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (!fileParam.isDirectory()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(fileParam.getPath()), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireDirectory(String filePathParam, String messageParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (!file.isDirectory()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }

        public final File requireExistingFile(File fileParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (!fileParam.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file exists: ".concat(fileParam.getPath()), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireExistingFile(String filePathParam, String messageParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (!file.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file exists: ".concat(filePathParam), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }

        public final File requireNotExistingFile(File fileParam, String messageParam) {
            Reqs.PARAM_REQ.Object.requireNotNull(fileParam, "Parameter fileParam must not be null.");
            if (fileParam.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file does not exist: ".concat(fileParam.getPath()), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return fileParam;
        }

        public final String requireNotExistingFile(String filePathParam, String messageParam) {
            Reqs.PARAM_REQ.String.requireNotBlank(filePathParam, "Parameter filePathParam must not be blank.");
            File file = new File(filePathParam);
            if (file.exists()) {
                String message = AbstractRequirements.this.concatenateStrings("Requires that file is a directory: ".concat(filePathParam), new String[]{messageParam});
                AbstractRequirements.this.onConditionNotMet(message);
            }
            return filePathParam;
        }
    };

    private String concatenateStrings(String stringParam, String ... stringsParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(stringParam, "Parameter stringParam must not be null.");
        String result = stringParam;
        if (stringsParam != null) {
            StringBuilder sb = new StringBuilder(stringParam);
            for (String current : stringsParam) {
                sb.append(" ").append(current);
            }
            result = sb.toString();
        }
        return result;
    }

    protected abstract void onConditionNotMet(String var1);
}

