/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.common.util;

import com.googlecode.jbp.common.requirements.Reqs;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Objects {
    public static <T> int compare(T firstParam, T secondParam, Comparator<? super T> comparatorParam) {
        return firstParam == secondParam ? 0 : comparatorParam.compare(firstParam, secondParam);
    }

    public static boolean deepEquals(Object firstParam, Object secondParam) {
        if (firstParam == secondParam) {
            return true;
        }
        if (firstParam == null || secondParam == null) {
            return false;
        }
        return Arrays.deepEquals((Object[])firstParam, (Object[])secondParam);
    }

    public static boolean equals(Object firstParam, Object secondParam) {
        return firstParam == secondParam || firstParam != null && firstParam.equals(secondParam);
    }

    public static int hash(Object ... objectsParam) {
        return Arrays.hashCode(objectsParam);
    }

    public static int hashCode(Object objectParam) {
        return objectParam != null ? objectParam.hashCode() : 0;
    }

    public static String toString(Object objectParam) {
        return Objects.toString(objectParam, "null");
    }

    public static String toString(Object objectParam, String nullDefaultParam) {
        Reqs.PARAM_REQ.Object.requireNotNull(nullDefaultParam, "A default value must be set to handle the case when the object is null.");
        return objectParam != null ? objectParam.toString() : nullDefaultParam;
    }

    private Objects() {
        throw new IllegalStateException("This object must not be instanciated.");
    }
}

