/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.jpa;

import com.googlecode.jbp.common.repository.IGenericRepository;
import com.googlecode.jbp.common.repository.IIdentifiable;
import com.googlecode.jbp.common.repository.IRepository;
import com.googlecode.jbp.common.repository.Page;
import com.googlecode.jbp.common.requirements.ParamRequirements;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaRepository<ID extends Serializable, DomainModel extends IIdentifiable<ID>, PersistenceModel extends DomainModel>
implements IRepository<ID, DomainModel> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(AbstractJpaRepository.class);
    private final EntityManager entityManager;
    private final IGenericRepository genericHibernateRepository;

    public AbstractJpaRepository(EntityManager entityManagerParam, IGenericRepository genericRepositoryParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)entityManagerParam, new String[0]);
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)genericRepositoryParam, new String[0]);
        this.genericHibernateRepository = genericRepositoryParam;
        this.entityManager = entityManagerParam;
    }

    public final DomainModel create(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entity, new String[0]);
        ParamRequirements.PARAM_REQ.Object.requireInstanceOf(entity, this.getPersistentClass(), new String[0]);
        return (DomainModel)this.genericHibernateRepository.create(entity);
    }

    protected final <ID extends Serializable, DomainModel extends IIdentifiable<ID>> CriteriaQuery<DomainModel> createCriteria(Class<DomainModel> persistentClassParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(persistentClassParam, new String[0]);
        return this.entityManager.getCriteriaBuilder().createQuery(persistentClassParam);
    }

    public void delete(Collection<DomainModel> entities) {
        this.genericHibernateRepository.delete(entities);
    }

    public void delete(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireInstanceOf(entity, this.getPersistentClass(), new String[0]);
        this.genericHibernateRepository.delete(entity);
    }

    public void delete(ID id) {
        this.genericHibernateRepository.delete(id, this.getPersistentClass());
    }

    public void deleteAll() {
        this.genericHibernateRepository.deleteAll(this.getPersistentClass());
    }

    public boolean exists(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireInstanceOf(entity, this.getPersistentClass(), new String[0]);
        return this.genericHibernateRepository.exists(entity);
    }

    public boolean exists(ID id) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(id, new String[0]);
        return this.genericHibernateRepository.exists(id, this.getPersistentClass());
    }

    public final void flush() {
        this.genericHibernateRepository.flush();
    }

    protected abstract Class<PersistenceModel> getPersistentClass();

    public List<DomainModel> retrieveAll() {
        return this.genericHibernateRepository.retrieveAll(this.getPersistentClass());
    }

    public List<DomainModel> retrieveAll(Page pageParam) {
        return this.genericHibernateRepository.retrieveAll(this.getPersistentClass(), pageParam);
    }

    protected final TypedQuery addPagingToQuery(TypedQuery queryParam, Page pageParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)queryParam, new String[0]);
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)pageParam, new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getFirstResult(), new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getMaxResults(), new String[0]);
        queryParam.setFirstResult(pageParam.getFirstResult()).setMaxResults(pageParam.getMaxResults());
        return queryParam;
    }

    public DomainModel retrieveById(ID id) {
        return (DomainModel)this.genericHibernateRepository.retrieveById(this.getPersistentClass(), id);
    }

    public void update(Collection<DomainModel> entities) {
        this.genericHibernateRepository.update(entities);
    }

    public void update(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireInstanceOf(entity, this.getPersistentClass(), new String[0]);
        this.genericHibernateRepository.update(entity);
    }
}

