/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jbp.jpa;

import com.googlecode.jbp.common.repository.IGenericRepository;
import com.googlecode.jbp.common.repository.IIdentifiable;
import com.googlecode.jbp.common.repository.Page;
import com.googlecode.jbp.common.requirements.ParamRequirements;
import com.googlecode.jbp.jpa.AbstractJpaRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaRepository
implements IGenericRepository {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(AbstractJpaRepository.class);
    private final EntityManager entityManager;

    public GenericJpaRepository(EntityManager entityManagerParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)entityManagerParam, new String[0]);
        this.entityManager = entityManagerParam;
    }

    protected final EntityManager getEntityManager() {
        return this.entityManager;
    }

    public final <ID extends Serializable, DomainModel extends IIdentifiable<ID>> DomainModel create(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entity, new String[0]);
        this.getEntityManager().persist(entity);
        return entity;
    }

    protected final <ID extends Serializable, DomainModel extends IIdentifiable<ID>> CriteriaQuery<DomainModel> createCriteria(Class<DomainModel> persistentClassParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(persistentClassParam, new String[0]);
        return this.getEntityManager().getCriteriaBuilder().createQuery(persistentClassParam);
    }

    public final <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void delete(Collection<DomainModel> entities) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entities, new String[0]);
        for (IIdentifiable current : entities) {
            this.delete(current);
        }
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void delete(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entity, new String[0]);
        IIdentifiable merged = (IIdentifiable)this.entityManager.merge(entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)merged);
        this.getEntityManager().flush();
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void delete(ID id, Class<DomainModel> persistentClassParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(id, new String[0]);
        IIdentifiable entity = (IIdentifiable)this.getEntityManager().find(persistentClassParam, id);
        if (entity != null) {
            this.getEntityManager().remove((Object)entity);
        }
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void deleteAll(Class<DomainModel> persistentClassParam) {
        this.delete((DomainModel)this.retrieveAll(persistentClassParam));
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> boolean exists(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entity, new String[0]);
        return this.getEntityManager().find(entity.getClass(), (Object)entity.getId()) != null;
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> boolean exists(ID id, Class<DomainModel> persistentClassParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(id, new String[0]);
        return this.getEntityManager().find(persistentClassParam, id) != null;
    }

    public final void flush() {
        LOGGER.trace("Session flush.");
        this.getEntityManager().flush();
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> List<DomainModel> retrieveAll(Class<DomainModel> persistentClassParam) {
        this.getEntityManager().flush();
        TypedQuery<DomainModel> q = this.buildQueryForRetrieveAll(persistentClassParam);
        return q.getResultList();
    }

    private <ID extends Serializable, DomainModel extends IIdentifiable<ID>> TypedQuery<DomainModel> buildQueryForRetrieveAll(Class<DomainModel> persistentClassParam) {
        CriteriaQuery<DomainModel> cq = this.createCriteria(persistentClassParam);
        Root root = cq.from(persistentClassParam);
        cq.select((Selection)root);
        return this.getEntityManager().createQuery(cq);
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> List<DomainModel> retrieveAll(Class<DomainModel> persistentClassParam, Page pageParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)pageParam, new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getFirstResult(), new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getMaxResults(), new String[0]);
        this.getEntityManager().flush();
        TypedQuery<DomainModel> q = this.buildQueryForRetrieveAll(persistentClassParam);
        return this.addPagingToQuery(q, pageParam).getResultList();
    }

    protected final TypedQuery addPagingToQuery(TypedQuery queryParam, Page pageParam) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)queryParam, new String[0]);
        ParamRequirements.PARAM_REQ.Object.requireNotNull((Object)pageParam, new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getFirstResult(), new String[0]);
        ParamRequirements.PARAM_REQ.Number.requireNotStrictlyNegative((Number)pageParam.getMaxResults(), new String[0]);
        queryParam.setFirstResult(pageParam.getFirstResult()).setMaxResults(pageParam.getMaxResults());
        return queryParam;
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> DomainModel retrieveById(Class<DomainModel> persistentClassParam, ID id) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(id, new String[0]);
        IIdentifiable entity = (IIdentifiable)this.getEntityManager().find(persistentClassParam, id);
        return (DomainModel)entity;
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void update(Collection<DomainModel> entities) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entities, new String[0]);
        for (IIdentifiable current : entities) {
            this.getEntityManager().merge((Object)current);
        }
    }

    public <ID extends Serializable, DomainModel extends IIdentifiable<ID>> void update(DomainModel entity) {
        ParamRequirements.PARAM_REQ.Object.requireNotNull(entity, new String[0]);
        this.getEntityManager().merge(entity);
    }
}

