/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw;

import com.googlecode.jdbw.BatchUpdateHandler;
import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.ExecuteResultHandler;
import com.googlecode.jdbw.SQLExecutor;
import com.googlecode.jdbw.TransactionIsolation;
import com.googlecode.jdbw.util.BatchUpdateHandlerAdapter;
import com.googlecode.jdbw.util.ExecuteResultHandlerAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class AutoExecutor
implements SQLExecutor {
    private final DataSource dataSource;
    private final DatabaseServerType serverType;
    private final TransactionIsolation transactionIsolation;
    private final int connectionErrorRetryInterval;
    private final TimeUnit connectionErrorRetryIntervalTimeUnit;
    private final int connectionErrorNrOfRetries;

    public AutoExecutor(DataSource dataSource, DatabaseServerType serverType) {
        this(dataSource, serverType, TransactionIsolation.READ_UNCOMMITTED);
    }

    public AutoExecutor(DataSource dataSource, DatabaseServerType serverType, TransactionIsolation transactionIsolation) {
        this(dataSource, serverType, transactionIsolation, 500, TimeUnit.MILLISECONDS, -1);
    }

    public AutoExecutor(DataSource dataSource, DatabaseServerType serverType, int connectionErrorNrOfRetries) {
        this(dataSource, serverType, TransactionIsolation.READ_UNCOMMITTED, 500, TimeUnit.MILLISECONDS, connectionErrorNrOfRetries);
    }

    public AutoExecutor(DataSource dataSource, DatabaseServerType serverType, TransactionIsolation transactionIsolation, int connectionErrorRetryInterval, TimeUnit connectionErrorRetryIntervalTimeUnit, int connectionErrorNrOfRetries) {
        this.dataSource = dataSource;
        this.serverType = serverType;
        this.transactionIsolation = transactionIsolation;
        this.connectionErrorRetryInterval = connectionErrorRetryInterval;
        this.connectionErrorRetryIntervalTimeUnit = connectionErrorRetryIntervalTimeUnit;
        this.connectionErrorNrOfRetries = connectionErrorNrOfRetries;
        assert (this.connectionErrorNrOfRetries >= -1);
        assert (this.connectionErrorRetryIntervalTimeUnit != null);
    }

    public void execute(String SQL, Object ... parameters) throws SQLException {
        this.execute((ExecuteResultHandler)new ExecuteResultHandlerAdapter(), SQL, parameters);
    }

    @Override
    public void execute(ExecuteResultHandler handler, String SQL, Object ... parameters) throws SQLException {
        this.execute(handler, 0, 0, SQL, parameters);
    }

    @Override
    public void execute(ExecuteResultHandler handler, int maxRowsToFetch, int queryTimeoutInSeconds, String SQL, Object ... parameters) throws SQLException {
        Connection connection = null;
        int attempt = 0;
        while (this.connectionErrorNrOfRetries == -1 || this.connectionErrorNrOfRetries > attempt) {
            try {
                connection = this.getNewConnection();
                SQLExecutor executor = this.createSQLExecutor(connection);
                executor.execute(handler, maxRowsToFetch, queryTimeoutInSeconds, SQL, parameters);
                return;
            }
            catch (SQLException e) {
                if (this.serverType.isConnectionError(e)) {
                    this.sleep(this.connectionErrorRetryIntervalTimeUnit.toMillis(this.connectionErrorRetryInterval));
                    ++attempt;
                    continue;
                }
                throw e;
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    public void batchWrite(String SQL, List<Object[]> parameters) throws SQLException {
        this.batchWrite(new BatchUpdateHandlerAdapter(), SQL, parameters);
    }

    @Override
    public void batchWrite(BatchUpdateHandler handler, String SQL, List<Object[]> parameters) throws SQLException {
        Connection connection = null;
        int attempt = 0;
        while (this.connectionErrorNrOfRetries == -1 || this.connectionErrorNrOfRetries > attempt) {
            try {
                connection = this.getNewConnection();
                SQLExecutor executor = this.createSQLExecutor(connection);
                executor.batchWrite(handler, SQL, parameters);
                return;
            }
            catch (SQLException e) {
                if (this.serverType.isConnectionError(e)) {
                    this.sleep(this.connectionErrorRetryIntervalTimeUnit.toMillis(this.connectionErrorRetryInterval));
                    ++attempt;
                    continue;
                }
                throw e;
            }
            finally {
                connection.close();
            }
        }
    }

    public void batchWrite(List<String> batchedSQL) throws SQLException {
        this.batchWrite(new BatchUpdateHandlerAdapter(), batchedSQL);
    }

    @Override
    public void batchWrite(BatchUpdateHandler handler, List<String> batchedSQL) throws SQLException {
        Connection connection = null;
        int attempt = 0;
        while (this.connectionErrorNrOfRetries == -1 || this.connectionErrorNrOfRetries > attempt) {
            try {
                connection = this.getNewConnection();
                SQLExecutor executor = this.createSQLExecutor(connection);
                executor.batchWrite(handler, batchedSQL);
                return;
            }
            catch (SQLException e) {
                if (this.serverType.isConnectionError(e)) {
                    this.sleep(this.connectionErrorRetryIntervalTimeUnit.toMillis(this.connectionErrorRetryInterval));
                    ++attempt;
                    continue;
                }
                throw e;
            }
            finally {
                connection.close();
            }
        }
    }

    private SQLExecutor createSQLExecutor(Connection connection) {
        return this.serverType.createExecutor(connection);
    }

    private Connection getNewConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        connection.setTransactionIsolation(this.transactionIsolation.getConstant());
        return connection;
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

