/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw;

public enum TransactionIsolation {
    READ_COMMITTED(2, "Read committed"),
    READ_UNCOMMITTED(1, "Read uncommited"),
    REPEATABLE_READ(4, "Repeatable read"),
    SERIALIZABLE(8, "Serializable");

    private final int level;
    private final String label;

    private TransactionIsolation(int level, String label) {
        this.level = level;
        this.label = label;
    }

    public int getConstant() {
        return this.level;
    }

    public String toString() {
        return this.label;
    }

    public static TransactionIsolation fromLabel(String label) {
        for (TransactionIsolation isolation : TransactionIsolation.values()) {
            if (!label.equals(isolation.label)) continue;
            return isolation;
        }
        return null;
    }

    public static TransactionIsolation fromLevel(int level) {
        for (TransactionIsolation isolation : TransactionIsolation.values()) {
            if (level != isolation.level) continue;
            return isolation;
        }
        return null;
    }
}

