/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.impl;

import com.googlecode.jdbw.DataSourceCloser;
import com.googlecode.jdbw.DataSourceFactory;
import com.googlecode.jdbw.DatabaseConnection;
import com.googlecode.jdbw.DatabaseConnectionFactory;
import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.impl.DatabaseConnectionImpl;
import com.googlecode.jdbw.util.OneSharedConnectionDataSource;
import java.util.Properties;
import javax.sql.DataSource;

public abstract class BasicDatabaseConnectionFactory
implements DatabaseConnectionFactory {
    private final DatabaseServerType databaseServerType;
    private final String jdbcUrl;
    private final Properties connectionProperties;

    public BasicDatabaseConnectionFactory(DatabaseServerType databaseServerType, String jdbcUrl) {
        this.databaseServerType = databaseServerType;
        this.jdbcUrl = jdbcUrl;
        this.connectionProperties = new Properties();
    }

    @Override
    public final DatabaseConnectionFactory setConnectionProperty(String propertyName, String value) {
        this.connectionProperties.setProperty(propertyName, value == null ? "" : value);
        return this;
    }

    @Override
    public DatabaseConnection connect(final DataSourceFactory dataSourceFactory) {
        return new DatabaseConnectionImpl(dataSourceFactory.newDataSource(this.jdbcUrl, this.connectionProperties), new DataSourceCloser(){

            @Override
            public void closeDataSource(DataSource dataSource) {
                dataSourceFactory.close(dataSource);
            }
        }, this.databaseServerType);
    }

    public DatabaseConnection connect() {
        return this.connect(new OneSharedConnectionDataSource.Factory());
    }
}

