/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.impl;

import com.googlecode.jdbw.AutoExecutor;
import com.googlecode.jdbw.DataSourceCloser;
import com.googlecode.jdbw.DatabaseConnection;
import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.DatabaseTransaction;
import com.googlecode.jdbw.TransactionIsolation;
import com.googlecode.jdbw.impl.DatabaseTransactionImpl;
import com.googlecode.jdbw.metadata.Catalog;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.util.OneSharedConnectionDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class DatabaseConnectionImpl
implements DatabaseConnection {
    private final DatabaseServerType databaseServerType;
    private final DataSource dataSource;
    private final DataSourceCloser dataSourceCloser;

    public DatabaseConnectionImpl(Connection connection) {
        this(connection, null);
    }

    public DatabaseConnectionImpl(Connection connection, DatabaseServerType databaseServerType) {
        this(new OneSharedConnectionDataSource(connection), new DataSourceCloser(){

            @Override
            public void closeDataSource(DataSource dataSource) {
                ((OneSharedConnectionDataSource)dataSource).close();
            }
        }, databaseServerType);
    }

    public DatabaseConnectionImpl(DataSource dataSource) {
        this(dataSource, null, null);
    }

    public DatabaseConnectionImpl(DataSource dataSource, DatabaseServerType databaseServerType) {
        this(dataSource, null, databaseServerType);
    }

    public DatabaseConnectionImpl(DataSource dataSource, DataSourceCloser dataSourceCloser) {
        this(dataSource, dataSourceCloser, null);
    }

    public DatabaseConnectionImpl(DataSource dataSource, DataSourceCloser dataSourceCloser, DatabaseServerType databaseServerType) {
        this.dataSource = dataSource;
        this.dataSourceCloser = dataSourceCloser;
        this.databaseServerType = databaseServerType != null ? databaseServerType : this.guessDatabaseServerType(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionIsolation getDefaultTransactionIsolation() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            TransactionIsolation transactionIsolation = TransactionIsolation.fromLevel(connection.getTransactionIsolation());
            return transactionIsolation;
        }
        catch (SQLException e) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.dataSourceCloser != null) {
            this.dataSourceCloser.closeDataSource(this.dataSource);
        }
    }

    @Override
    public DatabaseTransaction beginTransaction(TransactionIsolation transactionIsolation) throws SQLException {
        Connection connection = this.getConnection();
        return new DatabaseTransactionImpl(connection, this.getServerType().createExecutor(connection), transactionIsolation);
    }

    @Override
    public AutoExecutor createAutoExecutor() {
        return new AutoExecutor(this.dataSource, this.databaseServerType);
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public List<Catalog> getCatalogs() throws SQLException {
        ServerMetaData metaDataResolver = this.createMetaDataResolver();
        return metaDataResolver.getCatalogs();
    }

    @Override
    public Catalog getCatalog(String catalogName) throws SQLException {
        ServerMetaData metaDataResolver = this.createMetaDataResolver();
        return metaDataResolver.getCatalog(catalogName);
    }

    @Override
    public DatabaseServerType getServerType() {
        return this.databaseServerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultCatalogName() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = connection.getCatalog();
            return string;
        }
        catch (SQLException e) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    protected ServerMetaData createMetaDataResolver() {
        return this.getServerType().createMetaDataResolver(this.dataSource);
    }

    private DatabaseServerType guessDatabaseServerType(DataSource dataSource) {
        throw new IllegalArgumentException("Could not guess the database type of the supplied data source");
    }
}

