/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.impl;

import com.googlecode.jdbw.BatchUpdateHandler;
import com.googlecode.jdbw.DatabaseTransaction;
import com.googlecode.jdbw.ExecuteResultHandler;
import com.googlecode.jdbw.SQLExecutor;
import com.googlecode.jdbw.TransactionIsolation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class DatabaseTransactionImpl
implements DatabaseTransaction {
    private final TransactionIsolation transactionIsolation;
    private Connection connection;
    private SQLExecutor executor;
    private boolean initialized;

    DatabaseTransactionImpl(Connection connection, SQLExecutor executor, TransactionIsolation transactionIsolation) {
        this.connection = connection;
        this.transactionIsolation = transactionIsolation;
        this.executor = executor;
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() throws SQLException {
        this.executor = null;
        try {
            if (this.initialized) {
                this.connection.commit();
            }
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        }
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        this.executor = null;
        try {
            if (this.initialized) {
                this.connection.rollback();
            }
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        }
        this.connection = null;
    }

    @Override
    public void execute(ExecuteResultHandler handler, String SQL, Object ... parameters) throws SQLException {
        this.execute(handler, 0, 0, SQL, parameters);
    }

    @Override
    public void execute(ExecuteResultHandler handler, int maxRowsToFetch, int queryTimeout, String SQL, Object ... parameters) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Tried to call DefaultDatabaseTransaction.query after commit, rollback or revoked!");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.executor.execute(handler, maxRowsToFetch, queryTimeout, SQL, parameters);
    }

    @Override
    public synchronized void batchWrite(BatchUpdateHandler handler, String SQL, List<Object[]> parameters) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Tried to call DefaultDatabaseTransaction.query after commit, rollback or revoked!");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.executor.batchWrite(handler, SQL, parameters);
    }

    @Override
    public void batchWrite(BatchUpdateHandler handler, List<String> batchedSQL) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Tried to call DefaultDatabaseTransaction.query after commit, rollback or revoked!");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.executor.batchWrite(handler, batchedSQL);
    }

    private void initialize() throws SQLException {
        this.connection.setAutoCommit(false);
        this.connection.setTransactionIsolation(this.transactionIsolation.getConstant());
        this.initialized = true;
    }
}

