/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.impl;

import com.googlecode.jdbw.BatchUpdateHandler;
import com.googlecode.jdbw.ExecuteResultHandler;
import com.googlecode.jdbw.SQLExecutor;
import com.googlecode.jdbw.util.NullValue;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class SQLExecutorImpl
implements SQLExecutor {
    protected final Connection connection;

    protected SQLExecutorImpl(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void execute(ExecuteResultHandler handler, String SQL, Object ... parameters) throws SQLException {
        this.execute(handler, 0, 0, SQL, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecuteResultHandler handler, int maxRowsToFetch, int queryTimeoutInSeconds, String SQL, Object ... parameters) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareExecuteStatement(SQL);
            for (int i = 0; i < parameters.length; ++i) {
                this.setParameter(statement, parameters[i], i + 1);
            }
            statement.setQueryTimeout(queryTimeoutInSeconds);
            statement.setMaxRows(maxRowsToFetch);
            statement.execute();
            if (this.isInsertSQL(SQL)) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                while (generatedKeys.next()) {
                    handler.onGeneratedKey(generatedKeys.getObject(1));
                }
                generatedKeys.close();
            }
            do {
                if ((resultSet = statement.getResultSet()) != null) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    ArrayList<String> columnNames = new ArrayList<String>();
                    for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                        columnNames.add(resultSetMetaData.getColumnLabel(i + 1));
                    }
                    ArrayList<Integer> columnTypes = new ArrayList<Integer>();
                    for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                        columnTypes.add(resultSetMetaData.getColumnType(i + 1));
                    }
                    handler.onResultSet(columnNames, columnTypes);
                    SQLWarning warning = resultSet.getWarnings();
                    if (warning != null) {
                        handler.onWarning(warning);
                    }
                    boolean gotCancel = false;
                    while (resultSet.next() && !gotCancel) {
                        Object[] row = new Object[resultSetMetaData.getColumnCount()];
                        for (int i = 0; i < row.length; ++i) {
                            row[i] = resultSet.getObject(i + 1);
                        }
                        if (handler.nextRow(row)) continue;
                        gotCancel = true;
                    }
                } else {
                    int updateCount = statement.getUpdateCount();
                    if (updateCount == -1) break;
                    handler.onUpdateCount(updateCount);
                }
            } while (!statement.getMoreResults() || handler.nextResultSet());
            handler.onDone();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchWrite(BatchUpdateHandler handler, String SQL, List<Object[]> parameters) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareBatchUpdateStatement(SQL);
            for (Object[] row : parameters) {
                for (int i = 0; i < row.length; ++i) {
                    this.setParameter(statement, row[i], i + 1);
                }
                statement.addBatch();
            }
            int[] batchResult = statement.executeBatch();
            handler.onBatchResult(batchResult);
            SQLWarning warning = statement.getWarnings();
            if (warning != null) {
                handler.onWarning(warning);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchWrite(BatchUpdateHandler handler, List<String> batchedSQL) throws SQLException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            for (String row : batchedSQL) {
                statement.addBatch(row);
            }
            int[] batchResult = statement.executeBatch();
            handler.onBatchResult(Arrays.copyOf(batchResult, batchResult.length));
            SQLWarning warning = statement.getWarnings();
            if (warning != null) {
                handler.onWarning(warning);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected PreparedStatement prepareGeneralStatement(String SQL) throws SQLException {
        return this.connection.prepareStatement(SQL);
    }

    protected PreparedStatement prepareInsertStatement(String SQL) throws SQLException {
        return this.connection.prepareStatement(SQL, 1);
    }

    protected PreparedStatement prepareBatchUpdateStatement(String SQL) throws SQLException {
        return this.connection.prepareStatement(SQL, 2);
    }

    private PreparedStatement prepareExecuteStatement(String SQL) throws SQLException {
        if (this.isInsertSQL(SQL)) {
            return this.prepareInsertStatement(SQL);
        }
        return this.prepareGeneralStatement(SQL);
    }

    protected void executeUpdate(Statement statement, String SQL) throws SQLException {
        statement.executeUpdate(SQL, 1);
    }

    protected ResultSet getGeneratedKeys(Statement statement) throws SQLException {
        return statement.getGeneratedKeys();
    }

    protected void setParameter(PreparedStatement statement, Object object, int i) throws SQLException {
        if (object == null) {
            statement.setNull(i, 12);
        } else if (object instanceof NullValue.Binary) {
            statement.setNull(i, -2);
        } else if (object instanceof NullValue.Decimal) {
            statement.setNull(i, 3);
        } else if (object instanceof NullValue.Double) {
            statement.setNull(i, 8);
        } else if (object instanceof NullValue.Integer) {
            statement.setNull(i, 4);
        } else if (object instanceof NullValue.String) {
            statement.setNull(i, 12);
        } else if (object instanceof NullValue.Timestamp) {
            statement.setNull(i, 93);
        } else if (object instanceof String) {
            statement.setString(i, (String)object);
        } else if (object instanceof Byte) {
            statement.setByte(i, (Byte)object);
        } else if (object instanceof Short) {
            statement.setShort(i, (Short)object);
        } else if (object instanceof Integer) {
            statement.setInt(i, (Integer)object);
        } else if (object instanceof Long) {
            statement.setLong(i, (Long)object);
        } else if (object instanceof BigDecimal) {
            statement.setBigDecimal(i, (BigDecimal)object);
        } else if (object instanceof Date) {
            statement.setDate(i, (Date)object);
        } else if (object instanceof Double) {
            statement.setDouble(i, (Double)object);
        } else if (object instanceof Float) {
            statement.setFloat(i, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            statement.setBoolean(i, (Boolean)object);
        } else if (object instanceof Timestamp) {
            statement.setTimestamp(i, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            statement.setTimestamp(i, new Timestamp(((java.util.Date)object).getTime()));
        } else {
            statement.setObject(i, object);
        }
    }

    private boolean isInsertSQL(String SQL) {
        return SQL.trim().substring(0, "insert".length()).toLowerCase().equals("insert");
    }
}

