/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Schema;
import com.googlecode.jdbw.metadata.ServerMetaData;
import java.sql.SQLException;
import java.util.List;

public class Catalog
implements Comparable<Catalog> {
    private final ServerMetaData metaDataResolver;
    private final String name;

    public Catalog(ServerMetaData metaDataResolver, String name) {
        this.metaDataResolver = metaDataResolver;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Schema> getSchemas() throws SQLException {
        return this.metaDataResolver.getSchemas(this);
    }

    public Schema getSchema(String schemaName) throws SQLException {
        return this.metaDataResolver.getSchema(this, schemaName);
    }

    @Override
    public int compareTo(Catalog o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Catalog)) {
            return false;
        }
        Catalog other = (Catalog)obj;
        return this.metaDataResolver == other.metaDataResolver && this.getName().equals(other.getName());
    }
}

