/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Nullability;

public abstract class Column
implements Comparable<Column> {
    private final Integer ordinalPosition;
    private final String name;
    private final int sqlType;
    private final String typeName;
    private final int columnSize;
    private final int decimalDigits;
    private final Nullability nullable;
    private final String autoIncrement;

    public Column(int ordinalPosition, String columnName, int sqlType, String typeName, int columnSize, int decimalDigits, int nullable, String autoIncrement) {
        this.ordinalPosition = ordinalPosition;
        this.name = columnName;
        this.sqlType = sqlType;
        this.typeName = typeName;
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.nullable = nullable == 1 ? Nullability.NULLABLE : (nullable == 0 ? Nullability.NOT_NULLABLE : Nullability.UNKNOWN);
        this.autoIncrement = autoIncrement;
    }

    public String getAutoIncrement() {
        return this.autoIncrement;
    }

    public String getName() {
        return this.name;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public Nullability getNullable() {
        return this.nullable;
    }

    public Integer getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getNativeTypeName() {
        return this.typeName;
    }

    @Override
    public int compareTo(Column o) {
        return this.ordinalPosition.compareTo(o.ordinalPosition);
    }

    public String toString() {
        return this.getName() + " " + this.getNativeTypeName() + "(" + this.getColumnSize() + ")";
    }
}

