/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Catalog;
import com.googlecode.jdbw.metadata.Function;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Schema;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.metadata.StoredProcedure;
import com.googlecode.jdbw.metadata.SystemTable;
import com.googlecode.jdbw.metadata.Table;
import com.googlecode.jdbw.metadata.TableColumn;
import com.googlecode.jdbw.metadata.View;
import com.googlecode.jdbw.metadata.ViewColumn;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultServerMetaData
implements ServerMetaData {
    protected final DataSource dataSource;

    public DefaultServerMetaData(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Catalog> getCatalogs() throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<Catalog> result = new ArrayList<Catalog>();
            for (String catalogName : this.readResultSetColumn(this.getCatalogNames(pooledConnection), 1)) {
                result.add(this.createCatalog(catalogName));
            }
            ArrayList<Catalog> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    @Override
    public Catalog getCatalog(String catalogName) throws SQLException {
        for (Catalog catalog : this.getCatalogs()) {
            if (!catalog.getName().equals(catalogName)) continue;
            return catalog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Schema> getSchemas(Catalog catalog) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<Schema> arrayList;
            ArrayList<Schema> result = new ArrayList<Schema>();
            ResultSet resultSet = this.getSchemaMetadata(pooledConnection, catalog, null);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            try {
                while (resultSet.next()) {
                    if (resultSetMetaData.getColumnCount() < 2) {
                        result.add(this.createSchema(catalog, resultSet.getString(1)));
                        continue;
                    }
                    if (resultSet.getString(2) != null && !resultSet.getString(2).equals(catalog.getName())) continue;
                    result.add(this.createSchema(catalog, resultSet.getString(1)));
                }
                arrayList = result;
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Schema getSchema(Catalog catalog, String schemaName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Table> getTables(Schema schema) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<Table> result = new ArrayList<Table>();
            for (String tableName : this.readResultSetColumn(this.getTableMetadata(pooledConnection, schema, null), 3)) {
                result.add(this.createTable(schema, tableName));
            }
            ArrayList<Table> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(Schema schema, String tableName) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            for (String foundTableName : this.readResultSetColumn(this.getTableMetadata(pooledConnection, schema, tableName), 3)) {
                if (!foundTableName.equals(tableName)) continue;
                Table table = this.createTable(schema, foundTableName);
                return table;
            }
            Table table = null;
            return table;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SystemTable> getSystemTables(Schema schema) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<SystemTable> result = new ArrayList<SystemTable>();
            for (String tableName : this.readResultSetColumn(this.getSystemTableMetadata(pooledConnection, schema, null), 3)) {
                result.add(this.createSystemTable(schema, tableName));
            }
            ArrayList<SystemTable> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemTable getSystemTable(Schema schema, String systemTableName) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            for (String foundTableName : this.readResultSetColumn(this.getSystemTableMetadata(pooledConnection, schema, systemTableName), 3)) {
                if (!foundTableName.equals(systemTableName)) continue;
                SystemTable systemTable = this.createSystemTable(schema, foundTableName);
                return systemTable;
            }
            SystemTable systemTable = null;
            return systemTable;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<View> getViews(Schema schema) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<View> result = new ArrayList<View>();
            for (String viewName : this.readResultSetColumn(this.getViewMetadata(pooledConnection, schema, null), 3)) {
                result.add(this.createView(schema, viewName));
            }
            ArrayList<View> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View getView(Schema schema, String viewName) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            for (String foundViewName : this.readResultSetColumn(this.getViewMetadata(pooledConnection, schema, viewName), 3)) {
                if (!foundViewName.equals(viewName)) continue;
                View view = this.createView(schema, foundViewName);
                return view;
            }
            View view = null;
            return view;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableColumn> getColumns(Table table) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<TableColumn> result = new ArrayList<TableColumn>();
            ResultSet resultSet = this.getTableColumnMetadata(pooledConnection, table);
            while (resultSet.next()) {
                result.add(this.createTableColumn(table, resultSet.getInt("ORDINAL_POSITION"), resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), resultSet.getString("TYPE_NAME"), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), resultSet.getInt("NULLABLE"), resultSet.getString("IS_AUTOINCREMENT")));
            }
            ArrayList<TableColumn> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(Table table) throws SQLException {
        Map<String, TableColumn> tableColumns = table.getColumnMap();
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            HashMap<String, Index> result = new HashMap<String, Index>();
            ResultSet resultSet = this.getIndexMetadata(pooledConnection, table);
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                if (result.containsKey(indexName)) {
                    ((Index)result.get(indexName)).addColumn(tableColumns.get(columnName));
                    continue;
                }
                result.put(indexName, this.createIndex(table, indexName, resultSet.getShort("TYPE"), !resultSet.getBoolean("NON_UNIQUE"), tableColumns.get(columnName)));
            }
            List<Index> list = this.sortIndexList(new ArrayList<Index>(result.values()));
            return list;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ViewColumn> getColumns(View view) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<ViewColumn> result = new ArrayList<ViewColumn>();
            ResultSet resultSet = this.getViewColumnMetadata(pooledConnection, view);
            while (resultSet.next()) {
                result.add(this.createViewColumn(view, resultSet.getInt("ORDINAL_POSITION"), resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), resultSet.getString("TYPE_NAME"), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), resultSet.getInt("NULLABLE"), resultSet.getString("IS_AUTOINCREMENT")));
            }
            ArrayList<ViewColumn> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredProcedure> getStoredProcedures(Schema schema) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<StoredProcedure> result = new ArrayList<StoredProcedure>();
            for (String procedureName : this.readResultSetColumn(this.getStoredProcedureMetadata(pooledConnection, schema, null), 3)) {
                result.add(this.createStoredProcedure(schema, procedureName));
            }
            ArrayList<StoredProcedure> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredProcedure getStoredProcedure(Schema schema, String procedureName) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            for (String foundProcName : this.readResultSetColumn(this.getStoredProcedureMetadata(pooledConnection, schema, procedureName), 3)) {
                if (!foundProcName.equals(procedureName)) continue;
                StoredProcedure storedProcedure = this.createStoredProcedure(schema, foundProcName);
                return storedProcedure;
            }
            StoredProcedure storedProcedure = null;
            return storedProcedure;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getFunctions(Schema schema) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            ArrayList<Function> result = new ArrayList<Function>();
            for (String functionName : this.readResultSetColumn(this.getFunctionMetadata(pooledConnection, schema, null), 3)) {
                result.add(this.createFunction(schema, functionName));
            }
            ArrayList<Function> arrayList = result;
            return arrayList;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(Schema schema, String functionName) throws SQLException {
        Connection pooledConnection = this.dataSource.getConnection();
        try {
            for (String foundFunctionName : this.readResultSetColumn(this.getFunctionMetadata(pooledConnection, schema, functionName), 3)) {
                if (!foundFunctionName.equals(functionName)) continue;
                Function function = this.createFunction(schema, foundFunctionName);
                return function;
            }
            Function function = null;
            return function;
        }
        finally {
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> readResultSetColumn(ResultSet resultSet, int index) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (resultSet.next()) {
                list.add(resultSet.getString(index));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException e) {}
        }
    }

    protected Catalog createCatalog(String catalogName) {
        return new Catalog(this, catalogName);
    }

    protected Schema createSchema(Catalog catalog, String schemaName) {
        return new Schema(this, catalog, schemaName);
    }

    protected Table createTable(Schema schema, String tableName) {
        return new Table(this, schema, tableName);
    }

    private SystemTable createSystemTable(Schema schema, String tableName) {
        return new SystemTable(this, schema, tableName);
    }

    protected View createView(Schema schema, String viewName) {
        return new View(this, schema, viewName);
    }

    protected StoredProcedure createStoredProcedure(Schema schema, String procedureName) {
        return new StoredProcedure(this, schema, procedureName);
    }

    protected Function createFunction(Schema schema, String functionName) {
        return new Function();
    }

    protected TableColumn createTableColumn(Table table, int ordinalPosition, String columnName, int sqlType, String typeName, int columnSize, int decimalDigits, int nullable, String autoIncrement) {
        return new TableColumn(table, ordinalPosition, columnName, sqlType, typeName, columnSize, decimalDigits, nullable, autoIncrement);
    }

    protected ViewColumn createViewColumn(View view, int ordinalPosition, String columnName, int sqlType, String typeName, int columnSize, int decimalDigits, int nullable, String autoIncrement) {
        return new ViewColumn(view, ordinalPosition, columnName, sqlType, typeName, columnSize, decimalDigits, nullable, autoIncrement);
    }

    protected Index createIndex(Table table, String indexName, short type, boolean unique, TableColumn firstColumn) {
        boolean clustered = type == 1;
        boolean primaryKey = unique && clustered;
        return new Index(table, indexName, unique, clustered, primaryKey, firstColumn);
    }

    protected ResultSet getCatalogNames(Connection pooledConnection) throws SQLException {
        return pooledConnection.getMetaData().getCatalogs();
    }

    protected ResultSet getSchemaMetadata(Connection pooledConnection, Catalog catalog, String schemaName) throws SQLException {
        return pooledConnection.getMetaData().getSchemas(catalog != null ? catalog.getName() : null, schemaName);
    }

    protected ResultSet getTableMetadata(Connection pooledConnection, Schema schema, String tableName) throws SQLException {
        return pooledConnection.getMetaData().getTables(schema.getCatalog().getName(), schema.getName(), tableName, new String[]{"TABLE"});
    }

    protected ResultSet getSystemTableMetadata(Connection pooledConnection, Schema schema, String systemTableName) throws SQLException {
        return pooledConnection.getMetaData().getTables(schema.getCatalog().getName(), schema.getName(), systemTableName, new String[]{"SYSTEM TABLE"});
    }

    protected ResultSet getViewMetadata(Connection pooledConnection, Schema schema, String viewName) throws SQLException {
        return pooledConnection.getMetaData().getTables(schema.getCatalog().getName(), schema.getName(), viewName, new String[]{"VIEW"});
    }

    protected ResultSet getIndexMetadata(Connection pooledConnection, Table table) throws SQLException {
        return pooledConnection.getMetaData().getIndexInfo(table.getSchema().getCatalog().getName(), table.getSchema().getName(), table.getName(), false, false);
    }

    protected ResultSet getTableColumnMetadata(Connection pooledConnection, Table table) throws SQLException {
        return pooledConnection.getMetaData().getColumns(table.getSchema().getCatalog().getName(), table.getSchema().getName(), table.getName(), null);
    }

    protected ResultSet getViewColumnMetadata(Connection pooledConnection, View view) throws SQLException {
        return pooledConnection.getMetaData().getColumns(view.getSchema().getCatalog().getName(), view.getSchema().getName(), view.getName(), null);
    }

    protected ResultSet getStoredProcedureMetadata(Connection pooledConnection, Schema schema, String procedureName) throws SQLException {
        return pooledConnection.getMetaData().getProcedures(schema.getCatalog().getName(), schema.getName(), procedureName);
    }

    protected ResultSet getFunctionMetadata(Connection pooledConnection, Schema schema, String functionName) throws SQLException {
        return pooledConnection.getMetaData().getFunctions(schema.getCatalog().getName(), schema.getName(), functionName);
    }

    protected List<Index> sortIndexList(List<Index> indexes) {
        Collections.sort(indexes);
        return indexes;
    }
}

