/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Column;
import com.googlecode.jdbw.metadata.Table;
import com.googlecode.jdbw.metadata.TableColumn;
import com.googlecode.jdbw.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Index
implements Comparable<Index> {
    private final String name;
    private final boolean unique;
    private final boolean clustered;
    private final boolean primaryKey;
    private final Table table;
    private final List<TableColumn> columns;

    public Index(Table table, String indexName, boolean unique, boolean clustered, boolean primaryKey, TableColumn ... columns) {
        this.table = table;
        this.name = indexName;
        this.unique = unique;
        this.clustered = clustered;
        this.primaryKey = primaryKey;
        this.columns = new ArrayList<TableColumn>();
        this.columns.addAll(Arrays.asList(columns));
    }

    public void addColumn(TableColumn column) {
        if (column.getTable() != this.getTable()) {
            throw new IllegalArgumentException("Trying to add a column to an index from the wrong table!");
        }
        this.columns.add(column);
    }

    @Override
    public int compareTo(Index o) {
        if (this.primaryKey && !o.primaryKey) {
            return -1;
        }
        if (!this.primaryKey && o.primaryKey) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public int getNrOfColumns() {
        return this.columns.size();
    }

    public List<String> getColumnNames() {
        ArrayList<String> list = new ArrayList<String>(this.columns.size());
        for (TableColumn column : this.columns) {
            list.add(column.getName());
        }
        return list;
    }

    public List<Column> getColumns() {
        return new ArrayList<Column>(this.columns);
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Table getTable() {
        return this.table;
    }

    public String toString() {
        return this.name + "(" + StringUtils.concatenateStringList(this.getColumnNames(), ", ") + ")";
    }
}

