/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Catalog;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.metadata.StoredProcedure;
import com.googlecode.jdbw.metadata.Table;
import com.googlecode.jdbw.metadata.View;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schema
implements Comparable<Schema> {
    private final ServerMetaData metaDataResolver;
    private final Catalog catalog;
    private final String name;

    public Schema(ServerMetaData metaDataResolver, Catalog catalog, String name) {
        this.metaDataResolver = metaDataResolver;
        this.catalog = catalog;
        this.name = name;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getName() {
        return this.name;
    }

    public List<Table> getTables() throws SQLException {
        return this.metaDataResolver.getTables(this);
    }

    public Map<String, Table> getTableMap() throws SQLException {
        List<Table> tables = this.getTables();
        HashMap<String, Table> map = new HashMap<String, Table>();
        for (Table table : tables) {
            map.put(table.getName(), table);
        }
        return map;
    }

    public Table getTable(String tableName) throws SQLException {
        return this.metaDataResolver.getTable(this, tableName);
    }

    public List<View> getViews() throws SQLException {
        return this.metaDataResolver.getViews(this);
    }

    public View getView(String viewName) throws SQLException {
        return this.metaDataResolver.getView(this, viewName);
    }

    public List<StoredProcedure> getStoredProcedures() throws SQLException {
        return this.metaDataResolver.getStoredProcedures(this);
    }

    @Override
    public int compareTo(Schema o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public String toString() {
        return this.getCatalog().getName() + "." + this.getName();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Schema)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

