/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Schema;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.metadata.TableColumn;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Table
implements Comparable<Table> {
    private final ServerMetaData metaDataResolver;
    private final Schema schema;
    private final String name;

    public Table(ServerMetaData metaDataResolver, Schema schema, String tableName) {
        this.metaDataResolver = metaDataResolver;
        this.schema = schema;
        this.name = tableName;
    }

    public String getName() {
        return this.name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Index getUniqueKey() throws SQLException {
        if (this.getPrimaryKey() != null) {
            return this.getPrimaryKey();
        }
        for (Index index : this.getIndexes()) {
            if (!index.isUnique()) continue;
            return index;
        }
        return null;
    }

    public Index getPrimaryKey() throws SQLException {
        for (Index index : this.getIndexes()) {
            if (!index.isPrimaryKey()) continue;
            return index;
        }
        return null;
    }

    public List<TableColumn> getColumns() throws SQLException {
        return this.metaDataResolver.getColumns(this);
    }

    public List<Index> getIndexes() throws SQLException {
        return this.metaDataResolver.getIndexes(this);
    }

    public Map<String, Index> getIndexMap() throws SQLException {
        TreeMap<String, Index> indexMap = new TreeMap<String, Index>();
        for (Index index : this.getIndexes()) {
            indexMap.put(index.getName(), index);
        }
        return new HashMap<String, Index>(indexMap);
    }

    public TableColumn getColumn(String columnName) throws SQLException {
        for (TableColumn column : this.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public TableColumn getColumn(int columnIndex) throws SQLException {
        return this.getColumns().get(columnIndex);
    }

    public Map<String, TableColumn> getColumnMap() throws SQLException {
        TreeMap<String, TableColumn> columnMap = new TreeMap<String, TableColumn>();
        for (TableColumn column : this.getColumns()) {
            columnMap.put(column.getName(), column);
        }
        return new HashMap<String, TableColumn>(columnMap);
    }

    public int getColumnCount() throws SQLException {
        return this.getColumns().size();
    }

    @Override
    public int compareTo(Table o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public String toString() {
        return this.getSchema().getCatalog().getName() + "." + this.getSchema().getName() + "." + this.getName();
    }
}

