/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.metadata;

import com.googlecode.jdbw.metadata.Catalog;
import com.googlecode.jdbw.metadata.Schema;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.metadata.ViewColumn;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class View
implements Comparable<View> {
    private final ServerMetaData metaDataResolver;
    private final Schema schema;
    private final String name;

    public View(ServerMetaData metaDataResolver, Schema schema, String name) {
        this.metaDataResolver = metaDataResolver;
        this.schema = schema;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Catalog getCatalog() {
        return this.schema.getCatalog();
    }

    public List<ViewColumn> getColumns() throws SQLException {
        return this.metaDataResolver.getColumns(this);
    }

    public ViewColumn getColumn(String columnName) throws SQLException {
        for (ViewColumn column : this.metaDataResolver.getColumns(this)) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public ViewColumn getColumn(int columnIndex) throws SQLException {
        return this.getColumns().get(columnIndex);
    }

    public Map<String, ViewColumn> getColumnMap() throws SQLException {
        TreeMap<String, ViewColumn> columnMap = new TreeMap<String, ViewColumn>();
        for (ViewColumn column : this.getColumns()) {
            columnMap.put(column.getName(), column);
        }
        return new HashMap<String, ViewColumn>(columnMap);
    }

    public int getColumnCount() throws SQLException {
        return this.getColumns().size();
    }

    @Override
    public int compareTo(View o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public String toString() {
        return this.getSchema().getCatalog().getName() + "." + this.getSchema().getName() + "." + this.getName();
    }
}

