/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage;

import com.googlecode.jdbw.objectstorage.AbstractObjectStorage;
import com.googlecode.jdbw.objectstorage.ExternalObjectStorage;
import com.googlecode.jdbw.objectstorage.ObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.ObjectStorage;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.Storable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractExternalObjectStorage
extends AbstractObjectStorage
implements ExternalObjectStorage {
    private final ObjectStorage localStorage;

    public AbstractExternalObjectStorage(ObjectStorage backend) {
        this.localStorage = backend;
    }

    protected ObjectStorage getLocalStorage() {
        return this.localStorage;
    }

    @Override
    public ObjectBuilderFactory getBuilderFactory() {
        return this.localStorage.getBuilderFactory();
    }

    @Override
    protected <O extends Storable> Class<O> getStorableTypeFromObject(O object) throws ObjectStorageException {
        if (this.localStorage instanceof AbstractObjectStorage) {
            return ((AbstractObjectStorage)this.localStorage).getStorableTypeFromObject(object);
        }
        throw new ObjectStorageException("Cannot figure out which storable type to use for " + object + " of class " + object.getClass() + ", please override getStorableTypeFromObject(...) in " + this.getClass().getName());
    }

    @Override
    public <O extends Storable> boolean contains(O object) {
        if (this.localContains(object)) {
            return true;
        }
        return this.remoteContains(object);
    }

    @Override
    public <K, O extends Storable<K>> O get(Class<O> type, K key) {
        O object = this.localGet(type, key);
        if (object == null) {
            object = this.remoteGet(type, key);
        }
        return object;
    }

    @Override
    public <K, O extends Storable<K>> List<O> getSome(Class<O> type, Collection<K> keys) {
        List<O> objects = this.localStorage.getSome(type, keys);
        if (objects.isEmpty()) {
            objects = this.remoteGetSome(type, keys);
        }
        return objects;
    }

    @Override
    public <O extends Storable> List<O> getAll(Class<O> type) {
        List<O> objects = this.localStorage.getAll(type);
        if (objects.isEmpty()) {
            objects = this.remoteGetAll(type);
        }
        return objects;
    }

    @Override
    public <O extends Storable> int getSize(Class<O> type) {
        int size = this.localStorage.getSize(type);
        if (size == 0) {
            return this.remoteGetSize(type);
        }
        return size;
    }

    @Override
    public <O extends Storable> boolean localContains(O object) {
        return this.localStorage.contains(object);
    }

    @Override
    public <K, O extends Storable<K>> boolean localContains(Class<O> type, K key) {
        return this.localStorage.contains(type, key);
    }

    @Override
    public <K, O extends Storable<K>> O localGet(Class<O> type, K key) {
        return this.localStorage.get(type, key);
    }

    protected <O extends Storable> List<O> localGetAll(Class<O> type) {
        return this.localStorage.getAll(type);
    }

    protected <O extends Storable> void localPut(Collection<O> objects) {
        this.localStorage.putAll(objects);
    }

    @Override
    public <O extends Storable> void localRemove(O ... objects) {
        this.localStorage.remove((Storable[])objects);
    }

    @Override
    public <O extends Storable> void localRemove(Collection<O> objects) {
        this.localStorage.remove(objects);
    }

    @Override
    public <K, O extends Storable<K>> void localRemove(Class<O> objectType, K ... ids) {
        this.localStorage.remove(objectType, ids);
    }

    @Override
    public <K, O extends Storable<K>> void localRemove(Class<O> objectType, Collection<K> ids) {
        this.localStorage.remove(objectType, ids);
    }

    @Override
    public <K, O extends Storable<K>> void localRemoveAll(Class<O> objectType) {
        this.localStorage.removeAll(objectType);
    }

    @Override
    public <K, O extends Storable<K>> O remoteGet(Class<O> type, K key) {
        List<O> objects = this.remoteGetSome(type, Arrays.asList(key));
        if (!objects.isEmpty()) {
            return (O)((Storable)objects.get(0));
        }
        return null;
    }

    @Override
    public <K, O extends Storable<K>> O remoteGet(O object) {
        Class<O> objectType = this.getStorableTypeFromObject(object);
        return this.remoteGet(objectType, object.getId());
    }

    @Override
    public <K, O extends Storable<K>> List<O> remoteGetSome(Class<O> type, K ... keys) {
        return this.remoteGetSome(type, Arrays.asList(keys));
    }
}

