/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage;

import com.googlecode.jdbw.objectstorage.ObjectStorage;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.SelfDescribingStorable;
import com.googlecode.jdbw.objectstorage.Storable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractObjectStorage
implements ObjectStorage {
    @Override
    public <K, O extends Storable<K>> O get(Class<O> type, K id) {
        List<O> result = this.getSome(type, Arrays.asList(id));
        if (result.isEmpty()) {
            return null;
        }
        return (O)((Storable)result.get(0));
    }

    @Override
    public <K, O extends Storable<K>> boolean contains(Class<O> type, K id) {
        return this.get(type, id) != null;
    }

    @Override
    public <K, O extends Storable<K>> List<O> getSome(Class<O> type, K ... keys) {
        return this.getSome(type, Arrays.asList(keys));
    }

    @Override
    public <O extends Storable> List<O> putAll(O ... objects) {
        return this.putAll((Collection<O>)Arrays.asList(objects));
    }

    @Override
    public <O extends Storable> List<O> putAll(Collection<O> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Passing null to putAll(...) is not allowed");
        }
        ArrayList<Storable> toReturn = new ArrayList<Storable>();
        for (Storable object : objects) {
            if (object == null) continue;
            toReturn.add(this.put(object));
        }
        return toReturn;
    }

    @Override
    public <O extends Storable> void remove(O ... objects) {
        this.remove((Collection<O>)Arrays.asList(objects));
    }

    @Override
    public <O extends Storable> void remove(Collection<O> objects) {
        Class<Storable> type = null;
        ArrayList keysToRemove = new ArrayList();
        for (Storable object : objects) {
            if (object == null) continue;
            if (type == null && (type = this.getStorableTypeFromObject(object)) == null) {
                throw new ObjectStorageException("Couldn't derive the object type from " + object + " of type " + object.getClass());
            }
            keysToRemove.add(object.getId());
        }
        if (type != null) {
            this.remove(type, keysToRemove);
        }
    }

    @Override
    public <K, O extends Storable<K>> void remove(Class<O> objectType, K ... ids) {
        this.remove(objectType, Arrays.asList(ids));
    }

    protected <O extends Storable> Class<O> getStorableTypeFromObject(O object) throws ObjectStorageException {
        if (object instanceof SelfDescribingStorable) {
            return ((SelfDescribingStorable)((Object)object)).storableType();
        }
        return null;
    }
}

