/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.ObjectFactory;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.impl.ObjectProxyHandler;
import java.lang.reflect.Method;

class BuilderProxyHandler
extends ObjectProxyHandler {
    private final ObjectFactory objectFactory;

    BuilderProxyHandler(FieldMapping fieldMapping, ObjectFactory objectFactory, Object key) {
        super(fieldMapping, key, new Object[fieldMapping.getFieldNames().size()]);
        this.objectFactory = objectFactory;
    }

    BuilderProxyHandler(FieldMapping fieldMapping, ObjectFactory objectFactory, Object key, Object template) {
        this(fieldMapping, objectFactory, key);
        for (Method method : fieldMapping.getObjectType().getMethods()) {
            if (fieldMapping.getFieldName(method) == null || "getId".equals(method.getName())) continue;
            try {
                method.setAccessible(true);
                this.setFieldValue(method, method.invoke(template, new Object[0]));
            }
            catch (Exception e) {
                throw new ObjectStorageException("Couldn't copy value from template due to " + e.getClass().getSimpleName(), e);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("set") && method.getName().length() > 3) {
            this.setFieldValue(method, args[0]);
            return proxy;
        }
        if ("build".equals(method.getName())) {
            FieldMapping fieldMapping = this.getFieldMapping();
            Object[] idAndValues = new Object[this.getFields().length + 1];
            idAndValues[0] = this.getKey();
            System.arraycopy(this.getFields(), 0, idAndValues, 1, this.getFields().length);
            return this.objectFactory.newObject(fieldMapping.getObjectType(), fieldMapping, idAndValues);
        }
        return super.invoke(proxy, method, args);
    }

    @Override
    public String toString() {
        return "Builder:" + super.toString();
    }

    private void setFieldValue(Method method, Object value) {
        this.getFields()[this.getFieldMapping().getFieldIndex((Method)method)] = value;
    }
}

