/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.AbstractExternalObjectStorage;
import com.googlecode.jdbw.objectstorage.ObjectStorage;
import com.googlecode.jdbw.objectstorage.Storable;
import java.util.Collection;
import java.util.List;

public class CachedRemoteObjectStorage
extends AbstractExternalObjectStorage {
    private final ObjectStorage remoteObjectStorage;

    public CachedRemoteObjectStorage(ObjectStorage remoteObjectStorage, ObjectStorage localCache) {
        super(localCache);
        this.remoteObjectStorage = remoteObjectStorage;
    }

    @Override
    public <O extends Storable> void register(Class<O> objectType) {
        this.remoteObjectStorage.register(objectType);
        this.getLocalStorage().register(objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O extends Storable> O put(O object) {
        try {
            O o = this.remoteObjectStorage.put(object);
            return o;
        }
        finally {
            this.getLocalStorage().put(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O extends Storable> List<O> putAll(Collection<O> objects) {
        try {
            List<O> list = this.remoteObjectStorage.putAll(objects);
            return list;
        }
        finally {
            this.getLocalStorage().putAll(objects);
        }
    }

    @Override
    public <K, O extends Storable<K>> void remove(Class<O> objectType, Collection<K> ids) {
        this.remoteObjectStorage.remove(objectType, ids);
        this.localRemove(objectType, ids);
    }

    @Override
    public <O extends Storable> void removeAll(Class<O> objectType) {
        this.remoteObjectStorage.removeAll(objectType);
        this.localRemoveAll(objectType);
    }

    @Override
    public <O extends Storable> boolean remoteContains(O object) {
        return this.remoteObjectStorage.contains(object);
    }

    @Override
    public <K, O extends Storable<K>> boolean remoteContains(Class<O> type, K key) {
        return this.remoteObjectStorage.contains(type, key);
    }

    @Override
    public <K, O extends Storable<K>> List<O> remoteGetSome(Class<O> type, Collection<K> keys) {
        List<O> objects = this.remoteObjectStorage.getSome(type, keys);
        this.localPut(objects);
        return objects;
    }

    @Override
    public <O extends Storable> List<O> remoteGetAll(Class<O> type) {
        List<O> objects = this.remoteObjectStorage.getAll(type);
        this.localRemoveAll(type);
        this.localPut(objects);
        return objects;
    }

    @Override
    public <O extends Storable> int remoteGetSize(Class<O> type) {
        return this.remoteObjectStorage.getSize(type);
    }
}

