/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.ObjectCache;
import com.googlecode.jdbw.objectstorage.ObjectCacheFactory;
import com.googlecode.jdbw.objectstorage.Storable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapObjectCache
implements ObjectCache {
    private final ConcurrentHashMap<Object, Storable> hashMap = new ConcurrentHashMap();

    @Override
    public Storable get(Object key) {
        return this.hashMap.get(key);
    }

    @Override
    public Collection<Storable> values() {
        return this.hashMap.values();
    }

    @Override
    public void remove(Collection ids) {
        this.hashMap.keySet().removeAll(ids);
    }

    @Override
    public void removeAll() {
        this.hashMap.clear();
    }

    @Override
    public void put(Storable o) {
        this.hashMap.put(o.getId(), o);
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    public static class Factory
    implements ObjectCacheFactory {
        @Override
        public ObjectCache createObjectCache() {
            return new ConcurrentHashMapObjectCache();
        }
    }
}

