/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.Storable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultFieldMapping
implements FieldMapping {
    private final Class<? extends Storable> objectType;
    private final Map<String, Integer> fieldIndexMap;
    private final SortedMap<String, Class> fieldTypeMap;

    public DefaultFieldMapping(Class<? extends Storable> objectType) {
        this.objectType = objectType;
        this.fieldIndexMap = new TreeMap<String, Integer>();
        this.fieldTypeMap = new TreeMap<String, Class>();
        this.resolveFields();
    }

    @Override
    public Class<? extends Storable> getObjectType() {
        return this.objectType;
    }

    @Override
    public String getFieldName(Method method) {
        return this.getFieldName(method.getName());
    }

    @Override
    public String getFieldName(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fieldIndexMap.get(fieldName);
    }

    @Override
    public int getFieldIndex(Method method) {
        return this.getFieldIndex(this.getFieldName(method.getName()));
    }

    @Override
    public List<String> getFieldNames() {
        return new ArrayList<String>(this.fieldTypeMap.keySet());
    }

    @Override
    public List<Class> getFieldTypes() {
        return new ArrayList<Class>(this.fieldTypeMap.values());
    }

    private void resolveFields() {
        for (Method method : this.objectType.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            String fieldName = null;
            if (method.getName().startsWith("get")) {
                if (method.getName().equals("getId") || method.getName().length() <= 3) continue;
                fieldName = this.getFieldName(method.getName());
            } else if (method.getName().startsWith("is")) {
                if (method.getName().length() <= 2) continue;
                fieldName = this.getFieldName(method.getName());
            }
            if (fieldName == null) continue;
            this.fieldTypeMap.put(fieldName, method.getReturnType());
        }
        int index = 0;
        for (String fieldName : this.fieldTypeMap.keySet()) {
            this.fieldIndexMap.put(fieldName, index++);
        }
    }
}

