/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.ObjectBuilder;
import com.googlecode.jdbw.objectstorage.ObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.ObjectFactory;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.Storable;
import com.googlecode.jdbw.objectstorage.impl.BuilderProxyHandler;
import com.googlecode.jdbw.objectstorage.impl.DefaultFieldMapping;
import com.googlecode.jdbw.objectstorage.impl.ImmutableObjectFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DefaultObjectBuilderFactory
implements ObjectBuilderFactory {
    private final ObjectFactory objectFactory;

    public DefaultObjectBuilderFactory() {
        this(new ImmutableObjectFactory());
    }

    public DefaultObjectBuilderFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newClone(Class<B> builderType, O object) {
        return this.newObject(builderType, object.getId(), object);
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newObject(Class<B> builderType, K key) {
        return (B)((ObjectBuilder)this.newObjects(builderType, key).get(0));
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newObject(Class<B> builderType, K key, O template) {
        if (builderType == null) {
            throw new IllegalArgumentException("Passing null type to DefaultObjectBuilderFactory.newObject(...) is not allowed");
        }
        if (template == null) {
            throw new IllegalArgumentException("Passing null template to DefaultObjectBuilderFactory.newObject(...) is not allowed");
        }
        return this.newBuilderProxy(builderType, key, template);
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newObject(Class<B> builderType, K key, Map<String, Object> initialValues) {
        if (builderType == null) {
            throw new IllegalArgumentException("Passing null type to DefaultObjectBuilderFactory.newObject(...) is not allowed");
        }
        if (initialValues == null) {
            throw new IllegalArgumentException("Passing null initialValues to DefaultObjectBuilderFactory.newObject(...) is not allowed");
        }
        return this.newBuilderProxy(builderType, key, initialValues);
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> List<B> newObjects(Class<B> builderType, K ... keys) {
        return this.newObjects(builderType, (Collection<K>)Arrays.asList(keys));
    }

    @Override
    public <K, O extends Storable<K>, B extends ObjectBuilder<O>> List<B> newObjects(Class<B> builderType, Collection<K> keys) {
        if (builderType == null) {
            throw new IllegalArgumentException("Passing null type to ObjectBuilder.Factory.newObjects(...) is not allowed");
        }
        ArrayList<B> builders = new ArrayList<B>();
        for (K key : keys) {
            builders.add(this.newBuilderProxy(builderType, key));
        }
        return builders;
    }

    protected FieldMapping getFieldMapping(Class<? extends Storable> objectType) {
        return new DefaultFieldMapping(objectType);
    }

    private Class<? extends Storable> resolveStorable(Class builderType) {
        if (!ObjectBuilder.class.isAssignableFrom(builderType)) {
            return null;
        }
        for (Type type : builderType.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != ObjectBuilder.class || !Storable.class.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) continue;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new ObjectStorageException("Unknown storable type for builder " + builderType.getSimpleName());
    }

    private <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newBuilderProxy(Class<B> builderType, K key) throws IllegalArgumentException {
        return (B)((ObjectBuilder)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{builderType}, (InvocationHandler)new BuilderProxyHandler(this.getFieldMapping(this.resolveStorable(builderType)), this.objectFactory, key)));
    }

    private <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newBuilderProxy(Class<B> builderType, K key, O template) throws IllegalArgumentException {
        return (B)((ObjectBuilder)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{builderType}, (InvocationHandler)new BuilderProxyHandler(this.getFieldMapping(this.resolveStorable(builderType)), this.objectFactory, key, template)));
    }

    private <K, O extends Storable<K>, B extends ObjectBuilder<O>> B newBuilderProxy(Class<B> builderType, K key, Map<String, Object> initialValues) throws IllegalArgumentException {
        return (B)((ObjectBuilder)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{builderType}, (InvocationHandler)new BuilderProxyHandler(this.getFieldMapping(this.resolveStorable(builderType)), this.objectFactory, key, initialValues)));
    }
}

