/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.AbstractObjectStorage;
import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.FieldMappingFactory;
import com.googlecode.jdbw.objectstorage.ObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.ObjectCache;
import com.googlecode.jdbw.objectstorage.ObjectCacheFactory;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.Storable;
import com.googlecode.jdbw.objectstorage.impl.ConcurrentHashMapObjectCache;
import com.googlecode.jdbw.objectstorage.impl.DefaultFieldMappingFactory;
import com.googlecode.jdbw.objectstorage.impl.DefaultObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.impl.ObjectProxyHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultObjectStorage
extends AbstractObjectStorage {
    private final FieldMappingFactory fieldMappingFactory;
    private final ObjectCacheFactory objectCacheFactory;
    private final ConcurrentHashMap<Class, Cell> storageCells;

    public DefaultObjectStorage() {
        this(new DefaultFieldMappingFactory());
    }

    public DefaultObjectStorage(FieldMappingFactory fieldMappingFactory) {
        this(fieldMappingFactory, new ConcurrentHashMapObjectCache.Factory());
    }

    public DefaultObjectStorage(FieldMappingFactory fieldMappingFactory, ObjectCacheFactory objectCacheFactory) {
        this.fieldMappingFactory = fieldMappingFactory;
        this.objectCacheFactory = objectCacheFactory;
        this.storageCells = new ConcurrentHashMap();
    }

    @Override
    public <O extends Storable> void register(Class<O> objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Passing null to register(...) is not allowed");
        }
        this.storageCells.putIfAbsent(objectType, new Cell(this.fieldMappingFactory.createFieldMapping(objectType), this.objectCacheFactory.createObjectCache()));
    }

    @Override
    public <O extends Storable> boolean contains(O object) {
        if (object == null) {
            throw new IllegalArgumentException("Passing null object to contains(...) is not allowed");
        }
        Class<Object> objectType = object.getClass();
        if (object instanceof Proxy) {
            objectType = ((ObjectProxyHandler)Proxy.getInvocationHandler(object)).getObjectType();
        }
        return this.contains(objectType, object.getId());
    }

    @Override
    public <K, O extends Storable<K>> boolean contains(Class<O> type, K id) {
        if (!this.storageCells.containsKey(type)) {
            throw new IllegalArgumentException("Trying to call contains(...) on unregistered type " + type.getName());
        }
        return this.storageCells.get(type).get(id) != null;
    }

    @Override
    public <K, O extends Storable<K>> List<O> getSome(Class<O> type, Collection<K> keys) {
        if (type == null) {
            throw new IllegalArgumentException("Passing null type to getSome(...) is not allowed");
        }
        if (!this.storageCells.containsKey(type)) {
            throw new IllegalArgumentException("Trying to call getSome(...) on unregistered type " + type.getName());
        }
        ArrayList<Storable> toReturn = new ArrayList<Storable>();
        for (K key : keys) {
            Storable value = this.storageCells.get(type).get(key);
            if (value == null) continue;
            toReturn.add(value);
        }
        return toReturn;
    }

    @Override
    public <O extends Storable> List<O> getAll(Class<O> type) {
        if (type == null) {
            throw new IllegalArgumentException("Passing null type to getAll(...) is not allowed");
        }
        if (!this.storageCells.containsKey(type)) {
            throw new IllegalArgumentException("Trying to call getAll(...) on unregistered type " + type.getName());
        }
        return new ArrayList(this.storageCells.get(type).values());
    }

    @Override
    public <O extends Storable> int getSize(Class<O> type) {
        if (type == null) {
            throw new IllegalArgumentException("Passing null type to getSize(...) is not allowed");
        }
        if (!this.storageCells.containsKey(type)) {
            throw new IllegalArgumentException("Trying to call getSize(...) on unregistered type " + type.getName());
        }
        return this.storageCells.get(type).size();
    }

    @Override
    public ObjectBuilderFactory getBuilderFactory() {
        return new DefaultObjectBuilderFactory(){

            @Override
            protected FieldMapping getFieldMapping(Class<? extends Storable> objectType) {
                if (DefaultObjectStorage.this.storageCells.contains(objectType)) {
                    return ((Cell)DefaultObjectStorage.this.storageCells.get(objectType)).getFieldMapping();
                }
                return super.getFieldMapping(objectType);
            }
        };
    }

    @Override
    public <O extends Storable> O put(O object) {
        if (object == null) {
            throw new IllegalArgumentException("Passing null object to put(...) is not allowed");
        }
        Class<Object> objectType = object.getClass();
        if (object instanceof Proxy) {
            objectType = ((ObjectProxyHandler)Proxy.getInvocationHandler(object)).getObjectType();
        }
        if (!this.storageCells.containsKey(objectType)) {
            throw new IllegalArgumentException("Trying to call put(...) on unregistered type " + objectType.getName());
        }
        this.storageCells.get(objectType).put(object);
        return object;
    }

    @Override
    public <K, O extends Storable<K>> void remove(Class<O> objectType, Collection<K> ids) {
        if (objectType == null) {
            throw new IllegalArgumentException("Passing null object type to remove(...) is not allowed");
        }
        if (ids == null) {
            throw new IllegalArgumentException("Passing null ids to remove(...) is not allowed");
        }
        if (!this.storageCells.containsKey(objectType)) {
            throw new IllegalArgumentException("Trying to call remove(...) on unregistered type " + objectType.getName());
        }
        this.storageCells.get(objectType).remove(ids);
    }

    @Override
    public <O extends Storable> void removeAll(Class<O> objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Passing null object type to removeAll(...) is not allowed");
        }
        if (!this.storageCells.containsKey(objectType)) {
            throw new IllegalArgumentException("Trying to call removeAll(...) on unregistered type " + objectType.getName());
        }
        this.storageCells.get(objectType).removeAll();
    }

    @Override
    protected <O extends Storable> Class<O> getStorableTypeFromObject(O object) throws ObjectStorageException {
        InvocationHandler invocationHandler;
        Class<Object> type = super.getStorableTypeFromObject(object);
        if (type != null) {
            return type;
        }
        Class<?> candidate = object.getClass();
        if (this.storageCells.contains(candidate)) {
            type = candidate;
        } else if (object instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof ObjectProxyHandler) {
            type = ((ObjectProxyHandler)invocationHandler).getFieldMapping().getObjectType();
        }
        return type;
    }

    private static class Cell
    implements ObjectCache {
        final FieldMapping fieldMapping;
        final ObjectCache cache;

        public Cell(FieldMapping fieldMapping, ObjectCache cache) {
            this.fieldMapping = fieldMapping;
            this.cache = cache;
        }

        public FieldMapping getFieldMapping() {
            return this.fieldMapping;
        }

        @Override
        public Storable get(Object key) {
            return this.cache.get(key);
        }

        public Collection values() {
            return this.cache.values();
        }

        @Override
        public void remove(Collection ids) {
            this.cache.remove(ids);
        }

        @Override
        public void removeAll() {
            this.cache.removeAll();
        }

        @Override
        public void put(Storable o) {
            this.cache.put(o);
        }

        @Override
        public int size() {
            return this.cache.size();
        }
    }
}

