/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.SQLDialect;
import com.googlecode.jdbw.objectstorage.Storable;
import com.googlecode.jdbw.objectstorage.TableMapping;
import com.googlecode.jdbw.objectstorage.impl.DefaultFieldMapping;

public class DefaultTableMapping
extends DefaultFieldMapping
implements TableMapping {
    private final String tableName;

    public DefaultTableMapping(Class<? extends Storable> objectType) {
        this(objectType, objectType.getSimpleName());
    }

    public DefaultTableMapping(Class<? extends Storable> objectType, String tableName) {
        super(objectType);
        this.tableName = tableName;
    }

    @Override
    public String getColumnName(String fieldName) {
        return fieldName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getSelectAll(SQLDialect dialect) {
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(dialect.escapeIdentifier("id"));
        for (String fieldName : this.getFieldNames()) {
            sb.append(", ").append(dialect.escapeIdentifier(this.getColumnName(fieldName)));
        }
        sb.append(" FROM ").append(dialect.escapeIdentifier(this.getTableName()));
        return sb.toString();
    }

    @Override
    public String getSelectSome(SQLDialect dialect, int numberOfObjects) {
        if (numberOfObjects <= 0) {
            throw new IllegalArgumentException("Cannot call DefaultTableMapping.getSelectSome with numberOfObjects <= 0 ");
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        String idAsEscapedColumnName = dialect.escapeIdentifier(this.getColumnName("id"));
        sb.append(idAsEscapedColumnName);
        for (String fieldName : this.getFieldNames()) {
            sb.append(", ").append(dialect.escapeIdentifier(this.getColumnName(fieldName)));
        }
        sb.append(" FROM ").append(dialect.escapeIdentifier(this.getTableName()));
        sb.append(" WHERE ").append(idAsEscapedColumnName).append(" IN (?");
        for (int i = 1; i < numberOfObjects; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getSelectKeys(SQLDialect dialect, int numberOfObjects) {
        if (numberOfObjects <= 0) {
            throw new IllegalArgumentException("Cannot call DefaultTableMapping.getSelectKeys with numberOfObjects <= 0 ");
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        String idAsEscapedColumnName = dialect.escapeIdentifier(this.getColumnName("id"));
        sb.append(idAsEscapedColumnName);
        sb.append(" FROM ").append(dialect.escapeIdentifier(this.getTableName()));
        sb.append(" WHERE ").append(idAsEscapedColumnName).append(" IN (?");
        for (int i = 1; i < numberOfObjects; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getSelectCount(SQLDialect sqlDialect) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(");
        sb.append(sqlDialect.escapeIdentifier("id"));
        sb.append(") FROM ").append(sqlDialect.escapeIdentifier(this.getTableName()));
        return sb.toString();
    }

    @Override
    public String getSelectContains(SQLDialect sqlDialect) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(");
        sb.append(sqlDialect.escapeIdentifier("id"));
        sb.append(") FROM ").append(sqlDialect.escapeIdentifier(this.getTableName()));
        sb.append(" WHERE ").append(sqlDialect.escapeIdentifier("id")).append(" = ?");
        return sb.toString();
    }

    @Override
    public String getInsert(SQLDialect dialect) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(dialect.escapeIdentifier(this.getTableName()));
        sb.append(" (");
        sb.append(dialect.escapeIdentifier(this.getColumnName("id")));
        for (String fieldName : this.getFieldNames()) {
            sb.append(", ").append(dialect.escapeIdentifier(this.getColumnName(fieldName)));
        }
        sb.append(") VALUES(?");
        for (int i = 0; i < this.getFieldNames().size(); ++i) {
            sb.append(", ?");
        }
        return sb.append(")").toString();
    }

    @Override
    public String getUpdate(SQLDialect dialect) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append(dialect.escapeIdentifier(this.getTableName()));
        sb.append(" SET ");
        for (String fieldName : this.getFieldNames()) {
            sb.append(dialect.escapeIdentifier(this.getColumnName(fieldName))).append(" = ?, ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(" WHERE ");
        sb.append(dialect.escapeIdentifier(this.getColumnName("id")));
        return sb.append(" = ?").toString();
    }

    @Override
    public String getDelete(SQLDialect dialect, int numberOfObjectsToDelete) {
        if (numberOfObjectsToDelete <= 0) {
            throw new IllegalArgumentException("Cannot call DefaultTableMapping.getDelete(...) with numberOfObjectsToDelete <= 0");
        }
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(dialect.escapeIdentifier(this.getTableName()));
        sb.append(" WHERE ").append(dialect.escapeIdentifier("id")).append(" IN (?");
        for (int i = 1; i < numberOfObjectsToDelete; ++i) {
            sb.append(", ?");
        }
        return sb.append(")").toString();
    }

    @Override
    public String getDeleteAll(SQLDialect dialect) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(dialect.escapeIdentifier(this.getTableName()));
        return sb.toString();
    }
}

