/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.DatabaseConnection;
import com.googlecode.jdbw.DatabaseTransaction;
import com.googlecode.jdbw.TransactionIsolation;
import com.googlecode.jdbw.objectstorage.AbstractObjectStorage;
import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.ObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.ObjectFactory;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.Storable;
import com.googlecode.jdbw.objectstorage.TableMapping;
import com.googlecode.jdbw.objectstorage.TableMappingFactory;
import com.googlecode.jdbw.objectstorage.impl.DefaultObjectBuilderFactory;
import com.googlecode.jdbw.objectstorage.impl.DefaultTableMappingFactory;
import com.googlecode.jdbw.objectstorage.impl.ImmutableObjectFactory;
import com.googlecode.jdbw.objectstorage.impl.ObjectProxyHandler;
import com.googlecode.jdbw.objectstorage.impl.Utils;
import com.googlecode.jdbw.util.BatchUpdateHandlerAdapter;
import com.googlecode.jdbw.util.SQLWorker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCObjectStorage
extends AbstractObjectStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCObjectStorage.class);
    private final DatabaseConnection databaseConnection;
    private final TableMappingFactory tableMappingFactory;
    private final ObjectFactory objectFactory;
    private final ConcurrentHashMap<Class, TableMapping> tableMappings;
    private final int retryAttempts;

    public JDBCObjectStorage(DatabaseConnection databaseConnection) {
        this(databaseConnection, new DefaultTableMappingFactory());
    }

    public JDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory) {
        this(databaseConnection, tableMappingFactory, new ImmutableObjectFactory());
    }

    public JDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory, ObjectFactory objectFactory) {
        this(databaseConnection, tableMappingFactory, objectFactory, 3);
    }

    public JDBCObjectStorage(DatabaseConnection databaseConnection, TableMappingFactory tableMappingFactory, ObjectFactory objectFactory, int retryAttempts) {
        this.databaseConnection = databaseConnection;
        this.tableMappingFactory = tableMappingFactory;
        this.objectFactory = objectFactory;
        this.tableMappings = new ConcurrentHashMap();
        this.retryAttempts = retryAttempts;
    }

    protected DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    @Override
    public <O extends Storable> void register(Class<O> objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.register(...) with null object");
        }
        this.tableMappings.putIfAbsent(objectType, this.tableMappingFactory.createTableMapping(objectType));
    }

    @Override
    public ObjectBuilderFactory getBuilderFactory() {
        return new DefaultObjectBuilderFactory(){

            @Override
            protected FieldMapping getFieldMapping(Class<? extends Storable> objectType) {
                if (JDBCObjectStorage.this.tableMappings.contains(objectType)) {
                    return (FieldMapping)JDBCObjectStorage.this.tableMappings.get(objectType);
                }
                return super.getFieldMapping(objectType);
            }
        };
    }

    @Override
    public <O extends Storable> boolean contains(O object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.contains(...) with null object");
        }
        Class<O> objectType = this.getStorableTypeFromObject(object);
        return this.contains(objectType, object.getId());
    }

    @Override
    public <K, O extends Storable<K>> boolean contains(Class<O> type, K id) {
        if (type == null || !this.tableMappings.containsKey(type)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.contains(...) non-registered type " + type.getSimpleName());
        }
        TableMapping tableMapping = this.tableMappings.get(type);
        String sql = tableMapping.getSelectContains(this.databaseConnection.getServerType().getSQLDialect());
        try {
            int nrOfRows = new SQLWorker(this.databaseConnection.createAutoExecutor()).topLeftValueAsInt(sql, id);
            return nrOfRows > 0;
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.contains(...) with {type=" + type + ",id=" + id + "}", e);
        }
    }

    @Override
    public <K, O extends Storable<K>> List<O> getSome(Class<O> type, Collection<K> ids) {
        List<Object[]> rows;
        if (!this.tableMappings.containsKey(type)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.getSome(...) non-registered type " + type.getSimpleName());
        }
        TableMapping tableMapping = this.tableMappings.get(type);
        String sql = tableMapping.getSelectSome(this.databaseConnection.getServerType().getSQLDialect(), ids.size());
        try {
            Object[] keysAsArray = ids.toArray();
            rows = new SQLWorker(this.databaseConnection.createAutoExecutor()).query(sql, keysAsArray);
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.getSome(...) with {type=" + type + "} and {ids=" + ids + "}", e);
        }
        return this.transform(type, tableMapping, rows);
    }

    @Override
    public <O extends Storable> List<O> getAll(Class<O> type) {
        List<Object[]> rows;
        if (!this.tableMappings.containsKey(type)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.getAll(...) non-registered type " + type.getSimpleName());
        }
        TableMapping tableMapping = this.tableMappings.get(type);
        String sql = tableMapping.getSelectAll(this.databaseConnection.getServerType().getSQLDialect());
        try {
            rows = new SQLWorker(this.databaseConnection.createAutoExecutor()).query(sql, new Object[0]);
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.getAll(...) with {type=" + type + "}", e);
        }
        return this.transform(type, tableMapping, rows);
    }

    @Override
    public <O extends Storable> int getSize(Class<O> type) {
        int count;
        if (!this.tableMappings.containsKey(type)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.getSize(...) non-registered type " + type.getSimpleName());
        }
        String sql = this.tableMappings.get(type).getSelectCount(this.databaseConnection.getServerType().getSQLDialect());
        try {
            count = new SQLWorker(this.databaseConnection.createAutoExecutor()).topLeftValueAsInt(sql, new Object[0]);
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.getSize(...) with {type=" + type + "}", e);
        }
        return count;
    }

    @Override
    public <O extends Storable> O put(O object) {
        return (O)((Storable)this.putAll(new Storable[]{object}).get(0));
    }

    @Override
    public <O extends Storable> List<O> putAll(Collection<O> objects) {
        Class<Storable> objectType = null;
        if ((objects = Utils.removeNullElements(new ArrayList<O>(objects))).isEmpty()) {
            return Collections.emptyList();
        }
        Iterator i$ = objects.iterator();
        if (i$.hasNext()) {
            Storable object = (Storable)i$.next();
            objectType = this.getStorableTypeFromObject(object);
        }
        if (!this.tableMappings.containsKey(objectType)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.putAll(...) non-registered type " + objectType.getSimpleName());
        }
        TableMapping tableMapping = this.tableMappings.get(objectType);
        return this.doRetryingPutAll(objectType, objects, tableMapping);
    }

    @Override
    public <K, O extends Storable<K>> void remove(Class<O> objectType, Collection<K> ids) {
        if (!this.tableMappings.containsKey(objectType)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.remove(...) non-registered type " + objectType.getSimpleName());
        }
        String sql = this.tableMappings.get(objectType).getDelete(this.databaseConnection.getServerType().getSQLDialect(), ids.size());
        try {
            Object[] keysAsArray = ids.toArray();
            new SQLWorker(this.databaseConnection.createAutoExecutor()).write(sql, keysAsArray);
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.remove(...) with {type=" + objectType + "} and {ids=" + ids + "}", e);
        }
    }

    @Override
    public <O extends Storable> void removeAll(Class<O> objectType) {
        if (!this.tableMappings.containsKey(objectType)) {
            throw new IllegalArgumentException("Cannot call JDBCObjectStorage.getAll(...) non-registered type " + objectType.getSimpleName());
        }
        String sql = this.tableMappings.get(objectType).getDeleteAll(this.databaseConnection.getServerType().getSQLDialect());
        try {
            new SQLWorker(this.databaseConnection.createAutoExecutor()).write(sql, new Object[0]);
        }
        catch (SQLException e) {
            throw new ObjectStorageException("Database error when calling JDBCObjectStorage.removeAll(...) with {type=" + objectType + "}", e);
        }
    }

    @Override
    protected <O extends Storable> Class<O> getStorableTypeFromObject(O object) throws ObjectStorageException {
        InvocationHandler invocationHandler;
        Class<Object> type = super.getStorableTypeFromObject(object);
        if (type != null) {
            return type;
        }
        Class<?> candidate = object.getClass();
        if (this.tableMappings.contains(candidate)) {
            type = candidate;
        } else if (object instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof ObjectProxyHandler) {
            type = ((ObjectProxyHandler)invocationHandler).getFieldMapping().getObjectType();
        }
        return type;
    }

    protected <O extends Storable> List<O> transform(Class<O> type, FieldMapping fieldMapping, List<Object[]> rows) {
        ArrayList<O> result = new ArrayList<O>();
        for (Object[] row : rows) {
            result.add(this.objectFactory.newObject(type, fieldMapping, row));
        }
        return result;
    }

    protected <O extends Storable> Object[] transform(FieldMapping fieldMapping, O object) {
        return this.transform(fieldMapping, object, true);
    }

    protected <O extends Storable> Object[] transform(FieldMapping fieldMapping, O object, boolean idAtFirst) {
        Object[] result = new Object[fieldMapping.getFieldNames().size() + 1];
        if (idAtFirst) {
            result[0] = object.getId();
        }
        for (Method method : fieldMapping.getObjectType().getMethods()) {
            if (fieldMapping.getFieldName(method) == null || "getId".equals(method.getName())) continue;
            try {
                method.setAccessible(true);
                result[fieldMapping.getFieldIndex((Method)method) + (idAtFirst ? 1 : 0)] = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new ObjectStorageException("Failed transform, couldn't copy value from object due to " + e.getClass().getSimpleName(), e);
            }
        }
        if (!idAtFirst) {
            result[result.length - 1] = object.getId();
        }
        return result;
    }

    private <O extends Storable> List<O> doRetryingPutAll(Class<O> objectType, Collection<O> objects, TableMapping tableMapping) throws ObjectStorageException {
        for (int i = 0; i < this.retryAttempts; ++i) {
            try {
                this.doPutAll(objectType, objects, tableMapping);
                break;
            }
            catch (SQLException e) {
                if (i + 1 >= this.retryAttempts) {
                    throw new ObjectStorageException("Database error when calling JDBCObjectStorage.putAll(...) with {type=" + objectType + "} and {objects=" + objects + "}", e);
                }
                LOGGER.warn("Database error when calling JDBCObjectStorage.putAll(...) with type={} and objects={}, retrying attempt {} of {}...", new Object[]{objectType, objects, i + 1, this.retryAttempts});
                LOGGER.warn("Stack trace for the previous error", (Throwable)e);
                continue;
            }
        }
        return new ArrayList<O>(objects);
    }

    protected <O> void doPutAll(Class<O> objectType, Collection<O> objects, TableMapping tableMapping) throws SQLException {
        DatabaseTransaction transaction = null;
        try {
            ArrayList<Object[]> batch;
            int count = 0;
            Object[] allKeys = new Object[objects.size()];
            for (O object : objects) {
                allKeys[count++] = ((Storable)object).getId();
            }
            String sql = tableMapping.getSelectKeys(this.databaseConnection.getServerType().getSQLDialect(), objects.size());
            transaction = this.databaseConnection.beginTransaction(TransactionIsolation.REPEATABLE_READ);
            SQLWorker worker = new SQLWorker(transaction);
            HashSet<Object> existingRows = new HashSet<Object>(worker.leftColumn(sql, allKeys));
            ArrayList<O> toBeUpdated = new ArrayList<O>();
            ArrayList<O> toBeInserted = new ArrayList<O>();
            for (O object : objects) {
                if (existingRows.contains(((Storable)object).getId())) {
                    toBeUpdated.add(object);
                    continue;
                }
                toBeInserted.add(object);
            }
            if (!toBeInserted.isEmpty()) {
                sql = tableMapping.getInsert(this.databaseConnection.getServerType().getSQLDialect());
                batch = new ArrayList<Object[]>();
                for (Object o : toBeInserted) {
                    batch.add(this.transform(tableMapping, (Storable)o));
                }
                transaction.batchWrite(new BatchUpdateHandlerAdapter(), sql, batch);
            }
            if (!toBeUpdated.isEmpty()) {
                sql = tableMapping.getUpdate(this.databaseConnection.getServerType().getSQLDialect());
                batch = new ArrayList();
                for (Object o : toBeUpdated) {
                    batch.add(this.transform(tableMapping, (Storable)o, false));
                }
                transaction.batchWrite(new BatchUpdateHandlerAdapter(), sql, batch);
            }
            transaction.commit();
        }
        catch (SQLException e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SQLException e2) {
                LOGGER.debug("Database error when trying to rollback transaction after previous error (logged below)", (Throwable)e2);
            }
            throw e;
        }
    }
}

