/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.objectstorage.impl;

import com.googlecode.jdbw.objectstorage.FieldMapping;
import com.googlecode.jdbw.objectstorage.ObjectStorageException;
import com.googlecode.jdbw.objectstorage.Storable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ObjectProxyHandler
implements InvocationHandler {
    private final FieldMapping fieldMapping;
    private final Object key;
    private final Object[] fields;

    ObjectProxyHandler(FieldMapping fieldMapping, Object key, Object[] fields) {
        this.fieldMapping = fieldMapping;
        this.key = key;
        this.fields = fields;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getId")) {
            return this.getKey();
        }
        if (this.fieldMapping.getFieldName(method) != null) {
            if (method.getName().startsWith("set")) {
                throw new ObjectStorageException("Error trying to modify immutable object");
            }
            return this.fields[this.fieldMapping.getFieldIndex(method)];
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        if ("hashCode".equals(method.getName())) {
            return this.key.hashCode();
        }
        if ("equals".equals(method.getName()) && args != null && args.length == 1) {
            return this.fieldMapping.getObjectType().isAssignableFrom(args[0].getClass()) && this.key.equals(((Storable)args[0]).getId());
        }
        if ("storableType".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return this.fieldMapping.getObjectType();
        }
        throw new ObjectStorageException("Unknown method call: " + this.fieldMapping.getObjectType().getName() + "." + method.getName());
    }

    public Class<? extends Storable> getObjectType() {
        return this.fieldMapping.getObjectType();
    }

    public Object getKey() {
        return this.key;
    }

    protected Object[] getFields() {
        return this.fields;
    }

    protected FieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public String toString() {
        return this.fieldMapping.getObjectType().getSimpleName() + ":" + this.key;
    }
}

