/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server;

import com.googlecode.jdbw.DatabaseConnectionFactory;
import com.googlecode.jdbw.DatabaseServer;
import com.googlecode.jdbw.JDBCDriverDescriptor;
import com.googlecode.jdbw.impl.AuthenticatingDatabaseConnectionFactory;
import com.googlecode.jdbw.util.OneSharedConnectionDataSource;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public abstract class AbstractDatabaseServer
implements DatabaseServer {
    private final JDBCDriverDescriptor driverDescriptor;
    private static final Set<String> REGISTERED_DRIVERS = new ConcurrentSkipListSet<String>();

    public AbstractDatabaseServer(JDBCDriverDescriptor driverDescriptor) {
        this.driverDescriptor = driverDescriptor;
        this.registerJDBCDriver(driverDescriptor.getDriverClassName());
    }

    @Override
    public void testConnection(String username, String password) throws SQLException {
        DatabaseConnectionFactory connectionFactory = this.newConnectionFactory();
        if (connectionFactory instanceof AuthenticatingDatabaseConnectionFactory) {
            ((AuthenticatingDatabaseConnectionFactory)connectionFactory).setUsername(username);
            ((AuthenticatingDatabaseConnectionFactory)connectionFactory).setPassword(password);
        }
        connectionFactory.connect(new OneSharedConnectionDataSource.Factory()).close();
    }

    protected JDBCDriverDescriptor getDriverDescriptor() {
        return this.driverDescriptor;
    }

    private void registerJDBCDriver(String driverClassName) {
        if (REGISTERED_DRIVERS.add(driverClassName)) {
            try {
                Class.forName(driverClassName).newInstance();
            }
            catch (Exception e) {
                REGISTERED_DRIVERS.remove(driverClassName);
                throw new IllegalStateException("Unable to load the JDBC driver \"" + driverClassName + "\": " + e.getMessage());
            }
        }
    }
}

