/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server;

import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.SQLDialect;
import com.googlecode.jdbw.SQLExecutor;
import com.googlecode.jdbw.impl.SQLExecutorImpl;
import com.googlecode.jdbw.metadata.DefaultServerMetaData;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.server.DefaultSQLDialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientException;
import javax.sql.DataSource;

public abstract class AbstractDatabaseType
implements DatabaseServerType {
    @Override
    public SQLDialect getSQLDialect() {
        return new DefaultSQLDialect();
    }

    @Override
    public SQLExecutor createExecutor(Connection connection) {
        return new SQLExecutorImpl(connection){};
    }

    @Override
    public ServerMetaData createMetaDataResolver(DataSource dataSource) {
        return new DefaultServerMetaData(dataSource);
    }

    @Override
    public boolean isConnectionError(SQLException e) {
        if (e instanceof SQLTransientException) {
            return true;
        }
        if (e instanceof SQLNonTransientException) {
            return false;
        }
        if (e instanceof SQLRecoverableException) {
            return true;
        }
        if (e instanceof SQLSyntaxErrorException) {
            return false;
        }
        return false;
    }
}

