/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server;

import com.googlecode.jdbw.SQLDialect;
import com.googlecode.jdbw.metadata.Column;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.util.NullValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public class DefaultSQLDialect
implements SQLDialect {
    private static final Pattern decimalTimestampPattern = Pattern.compile("..............\\...?.?");
    private static final DateFormat decimalTimestampFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    private static final DateFormat defaultTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat defaultTimeFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    @Override
    public String escapeString(String string) {
        return string;
    }

    @Override
    public String escapeIdentifier(String identifier) {
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatDateTime(Date date) {
        DateFormat dateFormat = defaultTimestampFormat;
        synchronized (dateFormat) {
            return defaultTimestampFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatDate(Date date) {
        DateFormat dateFormat = defaultDateFormat;
        synchronized (dateFormat) {
            return defaultDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatTime(Date date) {
        DateFormat dateFormat = defaultTimeFormat;
        synchronized (dateFormat) {
            return defaultTimeFormat.format(date);
        }
    }

    @Override
    public String formatValue(Object value, int targetType) {
        if (value == null) {
            return "null";
        }
        if (DefaultSQLDialect.isBigDecimal(targetType)) {
            return this.formatDecimal(value);
        }
        if (DefaultSQLDialect.isBoolean(targetType)) {
            return this.formatBoolean(value);
        }
        if (DefaultSQLDialect.isFloatingPoint(targetType)) {
            return this.formatFloatingPoint(value);
        }
        if (DefaultSQLDialect.isString(targetType)) {
            return this.formatString(value);
        }
        if (DefaultSQLDialect.isInteger(targetType)) {
            return this.formatInteger(value);
        }
        if (DefaultSQLDialect.isDatetime(targetType)) {
            return this.formatDatetime(value);
        }
        if (DefaultSQLDialect.isDate(targetType)) {
            return this.formatDate(value);
        }
        if (DefaultSQLDialect.isTime(targetType)) {
            return this.formatTime(value);
        }
        if (DefaultSQLDialect.isBinary(targetType)) {
            return this.formatBinary(value);
        }
        throw new IllegalArgumentException("Called DefaultDatabaseServerTraits.formatValue with an unimplemented java.sql.Types constant (" + targetType + ")");
    }

    @Override
    public String[] getCreateTableStatement(String schemaName, String name, List<Column> columns, List<Index> indexes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDropTableStatement(String catalog, String schema, String tableName) {
        return "DROP TABLE " + (catalog != null ? catalog + "." : "") + (schema != null ? schema + "." : "") + tableName;
    }

    @Override
    public String getSingleLineCommentPrefix() {
        return "#";
    }

    @Override
    public String getDefaultSchemaName() {
        return "PUBLIC";
    }

    @Override
    public boolean isCompatible(int fromSqlType, int toSqlType) {
        if (fromSqlType == toSqlType) {
            return true;
        }
        Object exampleObject = this.createExampleObject(fromSqlType);
        return this.isCompatible(exampleObject, toSqlType);
    }

    private boolean isCompatible(Object value, int toSqlType) {
        try {
            this.formatValue(value, toSqlType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object safeType(Column targetColumn, Object object) {
        if (object == null) {
            return NullValue.fromSqlType(targetColumn.getSqlType());
        }
        if (object instanceof BigDecimal && DefaultSQLDialect.isDatetime(targetColumn.getSqlType())) {
            try {
                DateFormat dateFormat = decimalTimestampFormat;
                synchronized (dateFormat) {
                    return decimalTimestampFormat.parse(((BigDecimal)object).toPlainString());
                }
            }
            catch (ParseException e) {
                return object;
            }
        }
        if (object instanceof Date && DefaultSQLDialect.isBigDecimal(targetColumn.getSqlType()) && targetColumn.getColumnSize() == 17 && targetColumn.getDecimalDigits() == 3) {
            DateFormat dateFormat = decimalTimestampFormat;
            synchronized (dateFormat) {
                return new BigDecimal(decimalTimestampFormat.format((Date)object));
            }
        }
        if (object instanceof UUID && DefaultSQLDialect.isString(targetColumn.getSqlType())) {
            return object.toString();
        }
        return object;
    }

    protected Object createExampleObject(int sqlType) {
        if (DefaultSQLDialect.isBigDecimal(sqlType)) {
            return new BigDecimal("20100101000000.000");
        }
        if (DefaultSQLDialect.isBinary(sqlType)) {
            return new byte[1];
        }
        if (DefaultSQLDialect.isBoolean(sqlType)) {
            return true;
        }
        if (DefaultSQLDialect.isDate(sqlType)) {
            return new Date();
        }
        if (DefaultSQLDialect.isDatetime(sqlType)) {
            return new Date();
        }
        if (DefaultSQLDialect.isFloatingPoint(sqlType)) {
            return 17.3;
        }
        if (DefaultSQLDialect.isInteger(sqlType)) {
            return 17;
        }
        if (DefaultSQLDialect.isString(sqlType)) {
            return "sjutton";
        }
        if (DefaultSQLDialect.isTime(sqlType)) {
            return new Date();
        }
        throw new IllegalArgumentException("Called DefaultDatabaseServerTraits.createExampleObject with an unimplemented java.sql.Types constant (" + sqlType + ")");
    }

    public static boolean isBigDecimal(int sqlType) {
        return sqlType == 2 || sqlType == 3;
    }

    public static boolean isBoolean(int sqlType) {
        return sqlType == 16;
    }

    public static boolean isFloatingPoint(int sqlType) {
        return sqlType == 7 || sqlType == 8 || sqlType == 6;
    }

    public static boolean isString(int sqlType) {
        return sqlType == 1 || sqlType == 2005 || sqlType == -16 || sqlType == -1 || sqlType == -15 || sqlType == 2011 || sqlType == -9 || sqlType == 12;
    }

    public static boolean isInteger(int sqlType) {
        return sqlType == -6 || sqlType == 5 || sqlType == 4 || sqlType == -5;
    }

    public static boolean isDatetime(int sqlType) {
        return sqlType == 93;
    }

    public static boolean isDate(int sqlType) {
        return sqlType == 91;
    }

    public static boolean isTime(int sqlType) {
        return sqlType == 92;
    }

    public static boolean isBinary(int sqlType) {
        return sqlType == -2 || sqlType == -7 || sqlType == 2004 || sqlType == -4 || sqlType == -3;
    }

    protected String formatDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toString();
        }
        try {
            return new BigDecimal(value.toString()).toPlainString();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a decimal");
        }
    }

    protected String formatBoolean(Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (value instanceof String) {
            if (Boolean.parseBoolean((String)value)) {
                return "true";
            }
            return "false";
        }
        throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a boolean");
    }

    protected String formatFloatingPoint(Object value) {
        if (value instanceof Float || value instanceof Double) {
            return value.toString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        try {
            return new BigDecimal(value.toString()).toPlainString();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a floating point");
        }
    }

    protected String formatString(Object value) {
        return "'" + this.escapeString(value.toString()) + "'";
    }

    protected String formatInteger(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return value.toString();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toString();
        }
        try {
            return new BigDecimal(value.toString()).toBigInteger().toString();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to an integer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatDatetime(Object value) {
        if (value instanceof Date) {
            return "'" + this.formatDateTime((Date)value) + "'";
        }
        if (value instanceof BigDecimal && decimalTimestampPattern.matcher(((BigDecimal)value).toPlainString()).matches()) {
            try {
                DateFormat dateFormat = decimalTimestampFormat;
                synchronized (dateFormat) {
                    return this.formatDatetime(decimalTimestampFormat.parse(((BigDecimal)value).toPlainString()));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a datetime");
    }

    protected String formatDate(Object value) {
        if (value instanceof Date) {
            return "'" + this.formatDate((Date)value) + "'";
        }
        throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a date");
    }

    protected String formatTime(Object value) {
        if (value instanceof Date) {
            return "'" + this.formatTime((Date)value) + "'";
        }
        throw new IllegalArgumentException("Could not format type " + value.getClass().getName() + " to a time");
    }

    protected String formatBinary(Object value) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

