/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.h2;

import com.googlecode.jdbw.DataSourceFactory;
import com.googlecode.jdbw.DatabaseConnection;
import com.googlecode.jdbw.impl.AuthenticatingDatabaseConnectionFactory;
import com.googlecode.jdbw.server.h2.H2ServerType;
import com.googlecode.jdbw.util.OneSharedConnectionDataSource;

public class H2DatabaseConnectionFactory
extends AuthenticatingDatabaseConnectionFactory {
    private boolean allowMultipleConnections;

    public H2DatabaseConnectionFactory(H2ServerType databaseServerType, String jdbcUrl, boolean allowMultipleConnections) {
        super(databaseServerType, jdbcUrl);
        this.allowMultipleConnections = allowMultipleConnections;
    }

    @Override
    public H2DatabaseConnectionFactory setUsername(String username) {
        this.setConnectionProperty("USER", username);
        return this;
    }

    @Override
    public H2DatabaseConnectionFactory setPassword(String password) {
        this.setConnectionProperty("PASSWORD", password);
        return this;
    }

    @Override
    public DatabaseConnection connect(DataSourceFactory dataSourceFactory) {
        if (this.allowMultipleConnections) {
            return super.connect(dataSourceFactory);
        }
        return super.connect(new OneSharedConnectionDataSource.Factory());
    }
}

