/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.h2;

import com.googlecode.jdbw.DatabaseServerType;
import com.googlecode.jdbw.server.AbstractDatabaseServer;
import com.googlecode.jdbw.server.h2.H2DatabaseConnectionFactory;
import com.googlecode.jdbw.server.h2.H2JDBCDriverDescriptor;
import com.googlecode.jdbw.server.h2.H2ServerType;

public class H2DatabaseServer
extends AbstractDatabaseServer {
    private final H2ServerType serverType;
    private final String jdbcUrl;
    private final boolean allowMultipleConnections;

    protected H2DatabaseServer(H2ServerType serverType, String jdbcUrl, boolean allowMultipleConnections) {
        super(new H2JDBCDriverDescriptor());
        this.serverType = serverType;
        this.jdbcUrl = jdbcUrl;
        this.allowMultipleConnections = allowMultipleConnections;
    }

    @Override
    public DatabaseServerType getServerType() {
        return this.serverType;
    }

    @Override
    public H2DatabaseConnectionFactory newConnectionFactory() {
        return new H2DatabaseConnectionFactory(this.serverType, this.jdbcUrl, this.allowMultipleConnections);
    }
}

