/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.h2;

import com.googlecode.jdbw.JDBCDriverDescriptor;

public class H2JDBCDriverDescriptor
implements JDBCDriverDescriptor {
    public String formatJDBCUrlForAnonymousInMemory() {
        return "jdbc:h2:mem:";
    }

    public String formatJDBCUrlForInMemory(String name) {
        return "jdbc:h2:mem:" + name + ";DB_CLOSE_DELAY=-1";
    }

    public String formatJDBCUrlForFile(String databaseFilePrefix) {
        return "jdbc:h2:file:" + databaseFilePrefix;
    }

    @Override
    public String formatJDBCUrl(String host, int port, String defaultCatalog) {
        return "jdbc:h2:tcp://" + host + ":" + port + "/" + defaultCatalog;
    }

    @Override
    public String getDriverClassName() {
        return "org.h2.Driver";
    }
}

