/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.h2;

import com.googlecode.jdbw.metadata.Column;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Nullability;
import com.googlecode.jdbw.server.DefaultSQLDialect;
import com.googlecode.jdbw.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class H2SQLDialect
extends DefaultSQLDialect {
    @Override
    public String escapeIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public String[] getCreateTableStatement(String schemaName, String name, List<Column> columns, List<Index> indexes) {
        ArrayList<String> SQL = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE \"").append(name).append("\"(\n");
        for (Column column : columns) {
            sb.append("\t\"").append(column.getName()).append("\" ");
            sb.append(this.getH2Datatype(column));
            if (column.getNullable() == Nullability.NOT_NULLABLE) {
                sb.append(" NOT NULL");
            } else {
                sb.append(" NULL");
            }
            sb.append(",\n");
        }
        sb.delete(sb.length() - 2, sb.length()).append("\n");
        sb.append(")");
        SQL.add(sb.toString());
        for (Index index : indexes) {
            sb = new StringBuilder("CREATE ");
            if (index.isPrimaryKey()) {
                sb.append("PRIMARY KEY ");
            } else if (index.isUnique()) {
                sb.append("UNIQUE INDEX \"").append(name).append(".").append(index.getName()).append("\" ");
            } else {
                sb.append("INDEX \"").append(name).append(".").append(index.getName()).append("\" ");
            }
            sb.append(" ON \"").append(name).append("\" (\"");
            sb.append(StringUtils.concatenateStringList(index.getColumnNames(), "\",\""));
            sb.append("\")");
            SQL.add(sb.toString());
        }
        return SQL.toArray(new String[0]);
    }

    private String getH2Datatype(Column column) {
        if (H2SQLDialect.isBigDecimal(column.getSqlType())) {
            return "DECIMAL(" + column.getColumnSize() + ", " + column.getDecimalDigits() + ")";
        }
        if (H2SQLDialect.isBinary(column.getSqlType())) {
            return "VARBINARY(" + column.getColumnSize() + ")";
        }
        if (H2SQLDialect.isBoolean(column.getSqlType())) {
            return "BOOLEAN";
        }
        if (H2SQLDialect.isDate(column.getSqlType())) {
            return "DATE";
        }
        if (H2SQLDialect.isDatetime(column.getSqlType())) {
            return "DATETIME";
        }
        if (H2SQLDialect.isFloatingPoint(column.getSqlType())) {
            return "DOUBLE";
        }
        if (column.getSqlType() == -6) {
            return "TINYINT";
        }
        if (column.getSqlType() == 5) {
            return "SMALLINT";
        }
        if (column.getSqlType() == 4) {
            return "INT";
        }
        if (column.getSqlType() == -5) {
            return "BIGINT";
        }
        if (H2SQLDialect.isInteger(column.getSqlType())) {
            return "BIGINT";
        }
        if (H2SQLDialect.isString(column.getSqlType())) {
            return "VARCHAR(" + column.getColumnSize() + ")";
        }
        if (H2SQLDialect.isTime(column.getSqlType())) {
            return "TIME";
        }
        return "<UNKNOWN TYPE>";
    }
}

