/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.h2;

import com.googlecode.jdbw.SQLDialect;
import com.googlecode.jdbw.metadata.ServerMetaData;
import com.googlecode.jdbw.server.AbstractDatabaseType;
import com.googlecode.jdbw.server.h2.H2MetaDataResolver;
import com.googlecode.jdbw.server.h2.H2SQLDialect;
import javax.sql.DataSource;

public abstract class H2ServerType
extends AbstractDatabaseType {
    protected H2ServerType() {
    }

    @Override
    public SQLDialect getSQLDialect() {
        return new H2SQLDialect();
    }

    @Override
    public ServerMetaData createMetaDataResolver(DataSource dataSource) {
        return new H2MetaDataResolver(dataSource);
    }

    public static class Network
    extends H2ServerType {
        public static final Network INSTANCE = new Network();

        private Network() {
        }

        @Override
        public String getName() {
            return "H2 TCP/IP";
        }
    }

    public static class FileBased
    extends H2ServerType {
        public static final FileBased INSTANCE = new FileBased();

        private FileBased() {
        }

        @Override
        public String getName() {
            return "H2 file based";
        }
    }

    public static class InMemory
    extends H2ServerType {
        public static final InMemory INSTANCE = new InMemory();

        private InMemory() {
        }

        @Override
        public String getName() {
            return "H2 in-memory";
        }
    }
}

