/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.mysql;

import com.googlecode.jdbw.DatabaseServerTypes;
import com.googlecode.jdbw.impl.AuthenticatingDatabaseConnectionFactory;

public class MySQLDatabaseConnectionFactory
extends AuthenticatingDatabaseConnectionFactory {
    MySQLDatabaseConnectionFactory(String jdbcUrl) {
        super(DatabaseServerTypes.MYSQL, jdbcUrl);
        this.setUseUnicode(true);
        this.setCharacterEncoding("utf8");
        this.setRewriteBatchedStatements(true);
        this.setContinueBatchOnError(false);
        this.setAllowMultiQueriesboolean(false);
        this.setUseCompression(true);
        this.setZeroDateTimeBehavior("convertToNull");
    }

    @Override
    public MySQLDatabaseConnectionFactory setUsername(String username) {
        super.setUsername(username);
        return this;
    }

    @Override
    public MySQLDatabaseConnectionFactory setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    public final MySQLDatabaseConnectionFactory setUseUnicode(boolean useUnicode) {
        this.setConnectionProperty("useUnicode", useUnicode + "");
        return this;
    }

    public final MySQLDatabaseConnectionFactory setCharacterEncoding(String characterEncoding) {
        this.setConnectionProperty("characterEncoding", characterEncoding);
        return this;
    }

    public final MySQLDatabaseConnectionFactory setRewriteBatchedStatements(boolean rewriteBatchedStatements) {
        this.setConnectionProperty("rewriteBatchedStatements", rewriteBatchedStatements + "");
        return this;
    }

    public final MySQLDatabaseConnectionFactory setContinueBatchOnError(boolean continueBatchOnError) {
        this.setConnectionProperty("continueBatchOnError", continueBatchOnError + "");
        return this;
    }

    public final MySQLDatabaseConnectionFactory setAllowMultiQueriesboolean(boolean allowMultiQueries) {
        this.setConnectionProperty("allowMultiQueries", allowMultiQueries + "");
        return this;
    }

    public final MySQLDatabaseConnectionFactory setUseCompression(boolean useCompression) {
        this.setConnectionProperty("useCompression", useCompression + "");
        return this;
    }

    public final MySQLDatabaseConnectionFactory setZeroDateTimeBehavior(String zeroDateTimeBehavior) {
        this.setConnectionProperty("zeroDateTimeBehavior", zeroDateTimeBehavior);
        return this;
    }
}

