/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jdbw.server.mysql;

import com.googlecode.jdbw.metadata.Column;
import com.googlecode.jdbw.metadata.Index;
import com.googlecode.jdbw.metadata.Nullability;
import com.googlecode.jdbw.server.DefaultSQLDialect;
import com.googlecode.jdbw.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

class MySQLDialect
extends DefaultSQLDialect {
    private static final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat mysqlDecimalDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    private static final String HEXES = "0123456789ABCDEF";

    MySQLDialect() {
    }

    @Override
    protected String formatDecimal(Object value) {
        if (value instanceof Date) {
            return mysqlDecimalDateFormat.format((Date)value);
        }
        return super.formatDecimal(value);
    }

    private String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    @Override
    protected String formatBinary(Object value) {
        if (value instanceof byte[]) {
            return "UNHEX(" + this.getHex((byte[])value) + ")";
        }
        return super.formatBinary(value);
    }

    @Override
    public String escapeString(String string) {
        int last;
        StringBuilder buffer = new StringBuilder(string.length());
        int start = 0;
        int length = string.length();
        for (last = 0; last < length; ++last) {
            char c = string.charAt(last);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\"': 
                case '\'': 
                case '\\': {
                    buffer.append(string.substring(start, last));
                    start = last + 1;
                    buffer.append("\\").append(c);
                }
            }
        }
        return buffer.append(string.substring(start, last)).toString();
    }

    @Override
    public String escapeIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public synchronized String formatDateTime(Date timestamp) {
        return timestampFormat.format(timestamp);
    }

    @Override
    public Object safeType(Column targetColumn, Object object) {
        if (targetColumn.getSqlType() == 93 && object instanceof Date && "1900-01-01 00:00:00.0".equals(object.toString())) {
            return "1970-01-01 00:00:01";
        }
        return super.safeType(targetColumn, object);
    }

    @Override
    public String[] getCreateTableStatement(String schemaName, String name, List<Column> columns, List<Index> indexes) {
        return this.getCreateTableStatement(schemaName, name, columns, indexes, false);
    }

    public String[] getCreateTableStatement(String schemaName, String name, List<Column> columns, List<Index> indexes, boolean decimalDates) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE `").append(name).append("`(\n");
        for (Column column : columns) {
            sb.append("\t`").append(column.getName()).append("` ");
            sb.append(this.getMySQLDatatype(column, decimalDates));
            if (column.getNullable() == Nullability.NOT_NULLABLE) {
                sb.append(" NOT NULL");
            } else {
                sb.append(" NULL");
            }
            sb.append(",\n");
        }
        for (Index index : indexes) {
            if (index.isPrimaryKey()) {
                sb.append("\tPRIMARY KEY (`");
            } else if (index.isUnique()) {
                sb.append("\tUNIQUE INDEX `").append(index.getName()).append("`(`");
            } else {
                sb.append("\tINDEX `").append(index.getName()).append("`(`");
            }
            sb.append(StringUtils.concatenateStringList(index.getColumnNames(), "`,`"));
            sb.append("`),\n");
        }
        sb.delete(sb.length() - 2, sb.length()).append("\n");
        sb.append(") DEFAULT CHARACTER SET = UTF8, DEFAULT COLLATE = UTF8_BIN");
        return new String[]{sb.toString()};
    }

    @Override
    public String getDropTableStatement(String catalog, String schema, String tableName) {
        if (catalog != null) {
            return "DROP TABLE `" + catalog + "`.`" + tableName + "`";
        }
        return "DROP TABLE `" + tableName + "`";
    }

    @Override
    public String getDefaultSchemaName() {
        return "schema";
    }

    private String getMySQLDatatype(Column column, boolean decimalDates) {
        if (MySQLDialect.isBigDecimal(column.getSqlType())) {
            return "DECIMAL(" + column.getColumnSize() + ", " + column.getDecimalDigits() + ")";
        }
        if (MySQLDialect.isBinary(column.getSqlType())) {
            return "VARBINARY(" + column.getColumnSize() + ")";
        }
        if (MySQLDialect.isBoolean(column.getSqlType())) {
            return "BOOLEAN";
        }
        if (MySQLDialect.isDate(column.getSqlType())) {
            return "DATE";
        }
        if (MySQLDialect.isDatetime(column.getSqlType())) {
            if (decimalDates) {
                return "DECIMAL(17,3)";
            }
            return "DATETIME";
        }
        if (MySQLDialect.isFloatingPoint(column.getSqlType())) {
            return "DOUBLE";
        }
        if (column.getSqlType() == -6) {
            return "TINYINT";
        }
        if (column.getSqlType() == 5) {
            return "SMALLINT";
        }
        if (column.getSqlType() == 4) {
            return "INT";
        }
        if (column.getSqlType() == -5) {
            return "BIGINT";
        }
        if (MySQLDialect.isInteger(column.getSqlType())) {
            return "BIGINT";
        }
        if (MySQLDialect.isString(column.getSqlType())) {
            return "VARCHAR(" + column.getColumnSize() + ")";
        }
        if (MySQLDialect.isTime(column.getSqlType())) {
            return "TIME";
        }
        return "<UNKNOWN TYPE>";
    }
}

